<section class="relative pb-32 pt-48 text-center">
    <video
        class="absolute end-0 top-0 z-0 h-auto w-full rounded-t-xl mix-blend-lighten"
        data-src="{{ custom_theme_url('/assets/video/light-ray.mp4') }}"
        :src="modalOpen && $el.getAttribute('data-src')"
        muted
        loop
        playsinline
        autoplay
        loading="lazy"
    >
    </video>
    <div class="container relative z-1">
        <div class="mx-auto w-full lg:w-9/12">
            <h1 class="mb-6 text-[122px] leading-[0.9em] max-xl:text-[10vw] max-sm:text-[13vw]">
                @lang('New')
                <span class="block bg-gradient-to-tr from-[#9DE8EE] from-25% via-[#995BFF] via-50% to-[#8CEDD6] bg-clip-text text-transparent">
                    @lang('Exclusive')
                </span>
                @lang('Membership')
            </h1>
            <p class="mb-12 text-xl max-sm:text-[18px]">
                @lang('Our new premium membership grants you ')
                <span class="text-white">
                    @lang('exclusive access to all current and upcoming extensions, instant VIP Support and exclusive customizations for as low as $380/mo.')
                </span>
            </p>
            <div class="mx-auto w-full lg:w-10/12">
                {{-- <form
                    class="group relative"
                    action="https://marketplace.projecthub.ai/api/notify-me"
                    method="post"
                    x-data="{
                        async notifyMe(event) {
                            const form = event.target;
                            form.classList.add('lqd-is-busy');
                            fetch(form.action, {
                                    method: 'POST',
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    body: JSON.stringify({
                                        email: form.elements.email.value,
                                        domain: '{{ $domain }}'
                                    }),
                                })
                                .then(response => response.json())
                                .then(data => {
                                    if (data.message) {
                                        toastr.success(data.message);
                                    } else {
                                        toastr.error(data.message);
                                    }
                                })
                                .catch(error => {
                                    toastr.error(error.message);
                                })
                                .finally(() => {
                                    form.classList.remove('lqd-is-busy');
                                });
                        }
                    }"
                    @submit.prevent="notifyMe"
                >
                    <x-forms.input
                        class="scroll-mt-9 border-white/15 bg-white/10 text-lg text-white/90 backdrop-blur-md"
                        id="premium-support-form-input"
                        type="email"
                        name="email"
                        size="2xl"
                        placeholder="{{ __('Enter your email address') }}"
                    />
                    <button
                        class="size-10 absolute end-4 top-1/2 -translate-y-1/2 text-white transition-transform hover:scale-110"
                        type="submit"
                    >
                        <svg
                            class="group-[&.lqd-is-busy]:hidden"
                            width="19"
                            height="16"
                            viewBox="0 0 19 16"
                            fill="currentColor"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <path d="M0 16V10L8 8L0 6V0L19 8L0 16Z" />
                        </svg>
                        <x-tabler-refresh class="size-5 hidden animate-spin group-[&.lqd-is-busy]:block" />
                        <span class="sr-only">
                            @lang('Join the waitlist')
                        </span>
                    </button>
                    <div class="absolute end-0 top-0 translate-x-[50px] translate-y-8 max-md:hidden">
						<svg width="182" height="107" viewBox="0 0 182 107" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M11.5017 91.8559L9.76566 97.0639C9.76566 97.4372 9.64432 97.7452 9.40166 97.9879C8.35632 100.583 7.75899 102.001 7.60966 102.244C7.34832 102.673 7.21766 102.925 7.21766 103C7.21766 103.093 7.17099 103.14 7.07766 103.14C6.96566 103.215 6.90966 103.308 6.90966 103.42C6.81632 103.644 6.45232 104.083 5.81766 104.736C5.20166 105.408 4.74432 105.828 4.44566 105.996C3.75499 106.332 3.03632 106.416 2.28966 106.248C1.54299 106.08 0.936323 105.735 0.469657 105.212C0.33899 105.025 0.28299 104.745 0.301657 104.372C0.320323 104.017 0.376323 103.681 0.469657 103.364C0.56299 103.065 0.684323 102.916 0.833657 102.916C1.03899 102.916 1.27232 103.093 1.53366 103.448C2.54166 104.344 3.60566 103.924 4.72566 102.188C4.81899 101.964 5.06166 101.413 5.45366 100.536C6.48032 98.2959 7.03099 97.0452 7.10566 96.7839C7.18032 96.5225 7.26432 96.3359 7.35766 96.2239C7.35766 96.2052 7.40432 96.0559 7.49766 95.7759C7.59099 95.4959 7.66566 95.2345 7.72166 94.9919L8.89766 91.6599C9.08432 90.8012 9.26166 90.1665 9.42966 89.7559C9.61632 89.3265 9.95232 88.3839 10.4377 86.9279C11.203 84.4825 11.5577 83.2225 11.5017 83.1479L9.93366 83.4279C9.07499 83.7639 8.61766 83.7919 8.56166 83.5119C8.54299 83.4745 8.54299 83.4279 8.56166 83.3719V83.0639C8.50566 83.1012 8.42166 83.0639 8.30966 82.9519C8.08566 82.6905 7.97366 82.4105 7.97366 82.1119C7.97366 81.9625 8.19766 81.7945 8.64566 81.6079C9.09366 81.4025 9.52299 81.2719 9.93366 81.2159C10.3443 81.1599 10.8577 81.1039 11.4737 81.0479C12.1083 80.9732 12.5097 80.9265 12.6777 80.9079C12.771 80.8332 13.0697 80.9079 13.5737 81.1319C14.0777 81.3372 14.4043 81.5145 14.5537 81.6639C14.7403 82.0372 14.787 82.4012 14.6937 82.7559C14.619 83.1105 14.4043 83.7825 14.0497 84.7719C13.695 85.7425 13.4523 86.4052 13.3217 86.7599C13.2097 87.0959 13.0137 87.6652 12.7337 88.4679C12.099 90.2599 11.6883 91.3892 11.5017 91.8559Z" fill="white"/>
							<path d="M17.8863 94.8239C17.9236 94.7492 17.9796 94.6092 18.0543 94.4039C18.1289 94.1799 18.1943 94.0119 18.2502 93.8999C18.3249 93.7879 18.3623 93.5079 18.3623 93.0599C18.3809 92.5932 18.3156 92.3132 18.1663 92.2199C17.9609 92.1265 17.7929 92.0985 17.6623 92.1359C17.5316 92.1732 17.3169 92.2945 17.0183 92.4999C15.5996 93.6945 14.7503 94.9732 14.4703 96.3359C14.4143 96.8025 14.4609 97.1572 14.6103 97.3999C14.7783 97.6239 15.0489 97.6799 15.4223 97.5679C15.7956 97.4559 16.1316 97.2599 16.4303 96.9799C16.7289 96.6812 16.9249 96.4852 17.0183 96.3919C17.1116 96.2985 17.1863 96.2145 17.2423 96.1399C17.3169 96.0652 17.3823 95.9625 17.4383 95.8319C17.5129 95.6825 17.5689 95.5799 17.6063 95.5239C17.6436 95.4492 17.6903 95.3279 17.7463 95.1599C17.8209 94.9919 17.8676 94.8799 17.8863 94.8239ZM14.7223 91.1559C15.6556 90.3532 16.4956 89.8679 17.2423 89.6999C18.3623 89.4385 19.1463 89.5412 19.5943 90.0079C20.3223 90.3252 20.7423 90.9879 20.8543 91.9959C21.0036 93.5452 20.4903 95.1692 19.3143 96.8679C18.6236 97.8759 17.6716 98.7439 16.4583 99.4719C15.9729 99.8079 15.1143 100.013 13.8823 100.088C13.5649 100.088 13.2009 99.9105 12.7903 99.5559C11.9503 98.6785 11.5863 97.9039 11.6983 97.2319L11.7543 96.5879C11.6609 96.4945 11.6329 96.4199 11.6703 96.3639C11.7263 96.3079 11.7636 96.2705 11.7823 96.2519C11.8943 96.2519 11.9316 96.1679 11.8943 95.9999C11.8569 95.8132 11.9223 95.4679 12.0903 94.9639C12.2583 94.4599 12.4729 93.9932 12.7343 93.5639C13.3689 92.5185 14.0316 91.7159 14.7223 91.1559Z" fill="white"/>
							<path d="M22.5808 91.0159C22.6928 90.7359 22.9448 90.6705 23.3368 90.8199C23.7288 90.9505 24.0648 91.2305 24.3448 91.6599C24.5314 91.8652 24.5968 92.1732 24.5408 92.5839C24.5034 92.9759 24.2981 93.8345 23.9248 95.1599C23.5514 96.4665 23.3834 97.4372 23.4208 98.0719C23.3461 98.9119 23.2714 99.4905 23.1968 99.8079C23.1221 100.125 23.0101 100.275 22.8608 100.256C22.4128 100.256 22.0208 100.023 21.6848 99.5559C21.3674 99.0892 21.1714 98.5105 21.0968 97.8199C21.1714 97.1105 21.2274 96.6065 21.2648 96.3079C21.9181 93.3399 22.3568 91.5759 22.5808 91.0159ZM24.7088 84.8559C24.9141 84.8559 25.3434 84.9865 25.9968 85.2479C26.8368 87.0025 26.6501 88.1319 25.4368 88.6359C25.3061 88.7292 25.1288 88.7012 24.9048 88.5519C24.7181 88.5332 24.4661 88.3745 24.1488 88.0759C23.8501 87.7772 23.7008 87.5812 23.7008 87.4879C23.6634 87.0772 23.7288 86.5452 23.8968 85.8919C24.0648 85.2199 24.3354 84.8745 24.7088 84.8559Z" fill="white"/>
							<path d="M32.9309 97.6239L33.0709 95.7199V95.2719C33.0149 94.8985 32.8935 94.7119 32.7069 94.7119C32.3709 94.7119 31.7455 95.0385 30.8309 95.6919C29.1882 96.8679 27.9562 97.9879 27.1349 99.0519C26.9669 99.2385 26.8269 99.3505 26.7149 99.3879C26.6215 99.4065 26.4722 99.4065 26.2669 99.3879C26.0802 99.3692 25.8189 99.1825 25.4829 98.8279C25.1469 98.4732 24.9229 98.1559 24.8109 97.8759C24.8109 97.1292 25.1842 96.0279 25.9309 94.5719C26.0242 94.2732 26.2762 93.6292 26.6869 92.6399C27.1162 91.6319 27.3589 90.8572 27.4149 90.3159L27.3869 90.2879C27.3869 90.1012 27.4802 90.0079 27.6669 90.0079C27.7042 89.9519 27.8909 89.9239 28.2269 89.9239C28.5629 89.9239 28.9082 90.0545 29.2629 90.3159C29.6175 90.5772 29.7949 90.9412 29.7949 91.4079C29.7949 91.8745 29.5522 92.5932 29.0669 93.5639C28.5815 94.5345 28.3389 95.0385 28.3389 95.0759C28.6375 94.8705 29.2069 94.4412 30.0469 93.7879C31.9695 92.2385 33.1549 91.4639 33.6029 91.4639C33.8455 91.4639 34.1815 91.6039 34.6109 91.8839C35.0589 92.1452 35.3202 92.3879 35.3949 92.6119L35.2829 93.8999L35.3389 95.4399C35.3389 96.0372 35.3015 96.4572 35.2269 96.6999L35.3109 96.8679C35.2362 96.9425 35.3109 97.2225 35.5349 97.7079C35.7589 98.1932 35.8709 98.5012 35.8709 98.6319C35.8709 98.7439 35.7309 98.9305 35.4509 99.1919C35.1895 99.4345 34.9375 99.5745 34.6949 99.6119C33.5189 99.5745 32.9309 98.9119 32.9309 97.6239Z" fill="white"/>
							<path d="M42.8677 91.7159C42.793 91.7159 42.7557 91.5759 42.7557 91.2959V91.1559C42.7557 91.0999 42.709 91.0439 42.6157 90.9879C42.541 90.9319 42.4757 90.8759 42.4197 90.8199C42.3824 90.7452 42.4384 90.6052 42.5877 90.3999C42.737 90.1945 42.8677 90.0825 42.9797 90.0639C43.1104 90.0452 43.3157 90.0172 43.5957 89.9799C43.8944 89.9425 44.1557 89.9052 44.3797 89.8679C44.9957 89.7559 45.425 89.5505 45.6677 89.2519C46.377 87.4225 46.8904 86.3305 47.2077 85.9759C48.0104 85.5652 48.5984 85.6585 48.9717 86.2559C49.009 86.3119 49.065 86.3865 49.1397 86.4799C49.233 86.5545 49.2797 86.6105 49.2797 86.6479C49.2797 86.6852 49.261 86.7879 49.2237 86.9559C49.1864 87.1239 48.785 87.9452 48.0197 89.4199C48.2437 89.4572 48.5424 89.4572 48.9157 89.4199C49.4384 89.3079 49.877 89.2799 50.2317 89.3359C51.0157 89.3359 51.445 89.7652 51.5197 90.6239C51.613 91.1279 51.193 91.3799 50.2597 91.3799C48.337 91.4545 47.3664 91.5385 47.3477 91.6319C47.2544 91.6879 47.105 91.9772 46.8997 92.4999C46.6944 93.0225 46.5264 93.5172 46.3957 93.9839C45.8917 96.3172 45.901 97.7639 46.4237 98.3239C46.7037 98.6039 47.2824 98.3892 48.1597 97.6799C48.477 97.4185 48.7664 97.3345 49.0277 97.4279C49.3077 97.5212 49.457 97.7265 49.4757 98.0439C49.513 98.3425 49.429 98.6692 49.2237 99.0239C48.8877 99.5279 48.365 99.9292 47.6557 100.228C46.9464 100.527 46.3677 100.611 45.9197 100.48C45.4904 100.349 44.949 99.9945 44.2957 99.4159C43.997 99.0239 43.8104 98.6692 43.7357 98.3519C43.6797 98.0345 43.6517 97.6425 43.6517 97.1759V96.3639C43.6517 95.9345 43.941 94.5625 44.5197 92.2479C44.5757 92.0425 44.4824 91.9119 44.2397 91.8559C44.0157 91.7812 43.745 91.7532 43.4277 91.7719C43.1104 91.7719 42.9237 91.7532 42.8677 91.7159Z" fill="white"/>
							<path d="M57.6632 96.0839C57.7566 95.6545 57.8032 95.2252 57.8032 94.7959C57.8032 94.3665 57.7192 94.1519 57.5512 94.1519C57.0099 94.0585 55.5446 95.3652 53.1552 98.0719C52.4832 99.0239 52.1099 99.4999 52.0352 99.4999C51.5312 99.5185 51.1019 99.4065 50.7472 99.1639C50.3926 98.9025 50.1872 98.5852 50.1312 98.2119C50.1126 98.0065 50.8966 95.5519 52.4832 90.8479C52.5766 90.5865 52.8099 89.9892 53.1832 89.0559C53.5566 88.1039 53.7619 87.5719 53.7992 87.4599C53.8552 87.3292 54.0139 86.9279 54.2752 86.2559C54.8912 84.6879 55.2832 83.6425 55.4512 83.1199C55.4326 82.8025 55.4979 82.5412 55.6472 82.3359L56.0392 82.3079C56.0392 82.2705 56.1606 82.3079 56.4032 82.4199C56.6646 82.5319 56.9166 82.6719 57.1592 82.8399C57.4206 83.0079 57.5512 83.1385 57.5512 83.2319C57.7006 83.6985 57.5139 84.5852 56.9912 85.8919C56.8232 86.1159 56.5992 86.6199 56.3192 87.4039C56.0392 88.1692 55.8712 88.6172 55.8152 88.7479C55.1992 89.8679 54.6112 91.4172 54.0512 93.3959C53.8459 93.8812 53.7806 94.1799 53.8552 94.2919C53.9299 94.4039 54.1539 94.2359 54.5272 93.7879C55.2179 93.0599 55.7219 92.5372 56.0392 92.2199C56.3752 91.8839 56.7672 91.5665 57.2152 91.2679C57.6819 90.9692 58.0646 90.8292 58.3632 90.8479C58.6246 90.9039 58.9792 91.1372 59.4272 91.5479C59.8939 91.9399 60.1832 92.2852 60.2952 92.5839C60.4072 92.9945 60.4632 93.3959 60.4632 93.7879C60.4632 94.1799 60.4166 95.0199 60.3232 96.3079C60.1552 97.2599 60.0712 97.8292 60.0712 98.0159C60.0899 98.2025 60.2206 98.4079 60.4632 98.6319C60.7246 98.8372 60.8366 99.0985 60.7992 99.4159C60.7619 99.7145 60.6032 99.9385 60.3232 100.088C59.2966 100.368 58.5966 100.321 58.2232 99.9479C58.0926 99.8172 57.9526 99.6119 57.8032 99.3319C57.5419 98.7905 57.4486 98.1465 57.5232 97.3999C57.6166 96.6345 57.6632 96.1959 57.6632 96.0839Z" fill="white"/>
							<path d="M67.9462 91.5759C67.7035 91.3332 67.3488 91.3799 66.8822 91.7159C66.6955 91.7719 66.4342 91.9399 66.0982 92.2199C65.7808 92.4999 65.5102 92.7799 65.2862 93.0599C65.0622 93.3399 64.9968 93.5079 65.0902 93.5639C65.0715 93.6012 65.0902 93.6292 65.1462 93.6479C65.2208 93.6665 65.3048 93.6852 65.3982 93.7039C65.5102 93.7039 65.6128 93.7132 65.7062 93.7319C65.7995 93.7319 65.9675 93.7039 66.2102 93.6479C66.4715 93.5919 66.7235 93.4892 66.9662 93.3399C67.2275 93.1719 67.5262 92.8545 67.8622 92.3879C68.0115 91.9399 68.0395 91.6692 67.9462 91.5759ZM67.3862 95.4959C67.0128 95.5892 66.5555 95.6359 66.0142 95.6359C65.4915 95.6359 65.1462 95.5892 64.9782 95.4959C64.7728 95.3839 64.6235 95.5239 64.5302 95.9159L64.4462 96.5319C64.3715 97.0172 64.4928 97.4279 64.8102 97.7639C64.9595 97.9505 65.1928 98.0345 65.5102 98.0159C65.8275 97.9785 66.1075 97.8665 66.3502 97.6799C66.5928 97.4932 66.8542 97.2505 67.1342 96.9519C67.4142 96.6532 67.6195 96.4572 67.7502 96.3639C67.9368 96.0279 68.4035 95.9625 69.1502 96.1679C69.5608 96.4665 69.5048 97.0825 68.9822 98.0159C68.8888 98.2025 68.5995 98.5199 68.1142 98.9679C67.6475 99.4159 67.2742 99.7239 66.9942 99.8919C66.0235 100.396 64.9782 100.443 63.8582 100.032C62.4582 99.4719 61.8795 98.0905 62.1222 95.8879C62.1595 95.3465 62.1408 94.9732 62.0662 94.7679C62.0102 94.5439 61.9168 94.3852 61.7862 94.2919C61.6742 94.1799 61.5528 94.0679 61.4222 93.9559C61.1235 93.6759 60.9648 93.4799 60.9462 93.3679C60.9462 93.2559 60.9835 93.1065 61.0582 92.9199C61.1328 92.7145 61.1982 92.5932 61.2542 92.5559C61.6835 92.3692 61.9262 92.2852 61.9822 92.3039C62.0568 92.3039 62.1688 92.3505 62.3182 92.4439C62.4862 92.5372 62.5702 92.6212 62.5702 92.6959C62.6635 92.8825 62.8688 92.6865 63.1862 92.1079C63.2608 91.9585 63.3448 91.7905 63.4382 91.6039C63.6995 91.2119 64.0542 90.8292 64.5022 90.4559C64.9502 90.0639 65.3048 89.8025 65.5662 89.6719C65.8462 89.5225 66.2382 89.4012 66.7422 89.3079C67.2462 89.1959 67.6008 89.1492 67.8062 89.1679C68.4222 89.2239 69.0662 89.6065 69.7382 90.3159C70.0742 90.5585 70.2702 90.9972 70.3262 91.6319C70.3822 92.2479 70.3075 92.7425 70.1022 93.1159C70.0275 93.3959 69.6542 93.8252 68.9822 94.4039C68.3288 94.9639 67.7968 95.3279 67.3862 95.4959Z" fill="white"/>
							<path d="M83.091 95.9719C83.091 96.4012 83.175 96.6439 83.343 96.6999C83.399 96.7185 83.511 96.7279 83.679 96.7279C83.847 96.7279 84.0243 96.6532 84.211 96.5039C84.4163 96.3545 84.7056 96.0932 85.079 95.7199C85.4523 95.3465 85.919 94.7212 86.479 93.8439C87.039 92.9665 87.319 92.4625 87.319 92.3319C87.319 92.1825 87.403 92.0052 87.571 91.7999C88.1123 91.0159 88.6536 90.8945 89.195 91.4359C89.3816 91.6225 89.475 92.0612 89.475 92.7519C89.083 94.2079 88.775 95.0572 88.551 95.2999C88.1963 95.5799 87.8976 95.9252 87.655 96.3359C87.1323 96.9519 86.759 97.3532 86.535 97.5399C86.311 97.7265 86.171 97.8479 86.115 97.9039C85.5363 98.4825 84.8456 98.8839 84.043 99.1079C83.2403 99.3319 82.6523 99.2945 82.279 98.9959C81.7003 98.6972 81.411 98.1932 81.411 97.4839L81.271 96.8959C80.991 96.8959 80.739 97.0825 80.515 97.4559C80.3096 97.8292 79.8523 98.2585 79.143 98.7439C78.4523 99.2105 77.9296 99.4439 77.575 99.4439C77.1456 99.4439 76.735 99.0052 76.343 98.1279C75.9696 97.2319 75.8203 96.3359 75.895 95.4399C75.895 94.8239 75.951 94.2265 76.063 93.6479C76.1936 93.0692 76.2683 92.7425 76.287 92.6679C76.4363 91.5292 76.6696 90.7172 76.987 90.2319C77.3043 89.8025 77.687 89.6159 78.135 89.6719C78.6016 89.7279 78.863 89.9612 78.919 90.3719C79.0683 90.5399 79.1243 90.9225 79.087 91.5199C79.0496 92.1172 78.947 92.5279 78.779 92.7519C78.7416 92.8452 78.667 93.3212 78.555 94.1799C78.4616 95.0199 78.3963 95.5425 78.359 95.7479C78.2656 96.2892 78.359 96.5039 78.639 96.3919C78.9376 96.2612 79.339 95.8319 79.843 95.1039C80.347 94.3572 80.7016 93.7972 80.907 93.4239C81.1123 93.0505 81.3363 92.5185 81.579 91.8279C81.8216 91.1372 82.0363 90.6892 82.223 90.4839C82.4283 90.2599 82.6803 90.1572 82.979 90.1759C83.2963 90.1759 83.5856 90.2692 83.847 90.4559C84.3883 90.9972 84.435 91.7159 83.987 92.6119C83.3896 93.8065 83.091 94.9265 83.091 95.9719Z" fill="white"/>
							<path d="M95.2138 91.6039C94.5231 91.6039 93.3845 92.9385 91.7978 95.6079C91.5178 96.0559 91.2658 96.6439 91.0418 97.3719C91.3405 97.4092 91.9192 97.0732 92.7778 96.3639C92.9458 96.2145 93.1698 96.0185 93.4498 95.7759C93.7485 95.5332 93.9631 95.3559 94.0938 95.2439C94.2245 95.1319 94.3925 94.9825 94.5978 94.7959C94.9525 94.4412 95.2698 94.0585 95.5498 93.6479L96.1658 92.6399C95.8485 91.9492 95.5311 91.6039 95.2138 91.6039ZM88.6338 98.9119C88.6338 98.7439 88.5125 98.5105 88.2698 98.2119C87.9898 97.9319 88.5685 96.4759 90.0058 93.8439C90.1178 93.7319 90.2578 93.5359 90.4258 93.2559C90.6125 92.9759 90.7338 92.8172 90.7898 92.7799C90.7898 92.7052 90.8178 92.6399 90.8738 92.5839C90.9298 92.5092 90.9952 92.4719 91.0698 92.4719L91.2938 92.0239C91.3685 91.8559 91.7325 91.4545 92.3858 90.8199C93.0391 90.1852 93.5618 89.7465 93.9538 89.5039C94.3458 89.2612 94.7471 89.1492 95.1578 89.1679C95.5685 89.1865 95.9232 89.3172 96.2218 89.5599C96.2592 89.6159 96.3805 89.7185 96.5858 89.8679C96.9405 90.1479 97.7338 90.8385 98.9658 91.9399L98.4898 93.3399C98.0605 94.5719 98.1725 95.7105 98.8258 96.7559C99.0125 97.1479 99.3298 97.3812 99.7778 97.4559C100.226 97.5305 100.45 97.7359 100.45 98.0719C100.45 98.8372 100.198 99.2759 99.6938 99.3879C98.2378 99.5932 97.1458 98.9959 96.4178 97.5959C96.1565 97.2412 95.9885 96.8305 95.9138 96.3639C95.7831 96.5505 95.5685 96.7932 95.2698 97.0919C92.7311 99.6679 90.8085 100.536 89.5018 99.6959C89.4458 99.5839 89.2871 99.4345 89.0258 99.2479C88.7645 99.0612 88.6338 98.9492 88.6338 98.9119Z" fill="white"/>
							<path d="M101.784 91.0159C101.896 90.7359 102.148 90.6705 102.54 90.8199C102.932 90.9505 103.268 91.2305 103.548 91.6599C103.735 91.8652 103.8 92.1732 103.744 92.5839C103.707 92.9759 103.501 93.8345 103.128 95.1599C102.755 96.4665 102.587 97.4372 102.624 98.0719C102.549 98.9119 102.475 99.4905 102.4 99.8079C102.325 100.125 102.213 100.275 102.064 100.256C101.616 100.256 101.224 100.023 100.888 99.5559C100.571 99.0892 100.375 98.5105 100.3 97.8199C100.375 97.1105 100.431 96.6065 100.468 96.3079C101.121 93.3399 101.56 91.5759 101.784 91.0159ZM103.912 84.8559C104.117 84.8559 104.547 84.9865 105.2 85.2479C106.04 87.0025 105.853 88.1319 104.64 88.6359C104.509 88.7292 104.332 88.7012 104.108 88.5519C103.921 88.5332 103.669 88.3745 103.352 88.0759C103.053 87.7772 102.904 87.5812 102.904 87.4879C102.867 87.0772 102.932 86.5452 103.1 85.8919C103.268 85.2199 103.539 84.8745 103.912 84.8559Z" fill="white"/>
							<path d="M104.938 91.7159C104.863 91.7159 104.826 91.5759 104.826 91.2959V91.1559C104.826 91.0999 104.779 91.0439 104.686 90.9879C104.611 90.9319 104.546 90.8759 104.49 90.8199C104.453 90.7452 104.509 90.6052 104.658 90.3999C104.807 90.1945 104.938 90.0825 105.05 90.0639C105.181 90.0452 105.386 90.0172 105.666 89.9799C105.965 89.9425 106.226 89.9052 106.45 89.8679C107.066 89.7559 107.495 89.5505 107.738 89.2519C108.447 87.4225 108.961 86.3305 109.278 85.9759C110.081 85.5652 110.669 85.6585 111.042 86.2559C111.079 86.3119 111.135 86.3865 111.21 86.4799C111.303 86.5545 111.35 86.6105 111.35 86.6479C111.35 86.6852 111.331 86.7879 111.294 86.9559C111.257 87.1239 110.855 87.9452 110.09 89.4199C110.314 89.4572 110.613 89.4572 110.986 89.4199C111.509 89.3079 111.947 89.2799 112.302 89.3359C113.086 89.3359 113.515 89.7652 113.59 90.6239C113.683 91.1279 113.263 91.3799 112.33 91.3799C110.407 91.4545 109.437 91.5385 109.418 91.6319C109.325 91.6879 109.175 91.9772 108.97 92.4999C108.765 93.0225 108.597 93.5172 108.466 93.9839C107.962 96.3172 107.971 97.7639 108.494 98.3239C108.774 98.6039 109.353 98.3892 110.23 97.6799C110.547 97.4185 110.837 97.3345 111.098 97.4279C111.378 97.5212 111.527 97.7265 111.546 98.0439C111.583 98.3425 111.499 98.6692 111.294 99.0239C110.958 99.5279 110.435 99.9292 109.726 100.228C109.017 100.527 108.438 100.611 107.99 100.48C107.561 100.349 107.019 99.9945 106.366 99.4159C106.067 99.0239 105.881 98.6692 105.806 98.3519C105.75 98.0345 105.722 97.6425 105.722 97.1759V96.3639C105.722 95.9345 106.011 94.5625 106.59 92.2479C106.646 92.0425 106.553 91.9119 106.31 91.8559C106.086 91.7812 105.815 91.7532 105.498 91.7719C105.181 91.7719 104.994 91.7532 104.938 91.7159Z" fill="white"/>
							<path d="M111.922 97.3159C112.388 95.0572 112.734 93.6665 112.958 93.1439C113.07 92.7892 113.172 92.4625 113.266 92.1639C113.826 90.3532 114.348 89.1305 114.834 88.4959C114.852 88.4585 114.88 88.3932 114.918 88.2999C114.955 88.1879 114.983 88.1132 115.002 88.0759C115.002 87.7772 115.067 87.5159 115.198 87.2919C115.422 86.9559 115.59 86.6292 115.702 86.3119L116.486 84.7159C116.672 84.1745 116.971 83.8199 117.382 83.6519L117.354 83.6239C117.447 83.4745 117.615 83.3439 117.858 83.2319C118.119 83.1199 118.343 83.0639 118.53 83.0639C119.071 83.0639 119.342 83.3439 119.342 83.9039C119.342 84.3892 119.267 84.7252 119.118 84.9119H119.146C118.922 85.5465 118.754 85.9199 118.642 86.0319C118.548 86.1439 118.138 86.8999 117.41 88.2999C116.551 89.9612 116.047 91.0812 115.898 91.6599C115.86 91.7345 115.786 91.8932 115.674 92.1359C115.58 92.3785 115.524 92.5185 115.506 92.5559L115.058 94.2919L114.946 94.8799C114.647 95.7012 114.479 96.2052 114.442 96.3919C114.348 96.6532 114.292 96.8212 114.274 96.8959C114.274 96.9705 114.208 97.1945 114.078 97.5679C113.798 98.4825 113.639 99.2572 113.602 99.8919L113.574 100.004C113.518 100.415 113.396 100.723 113.21 100.928C113.042 101.133 112.818 101.199 112.538 101.124C111.996 100.937 111.707 100.499 111.67 99.8079C111.651 99.0985 111.735 98.2679 111.922 97.3159Z" fill="white"/>
							<path d="M116.096 99.0239L115.956 98.4639C115.508 98.2399 115.349 97.9319 115.48 97.5399C115.741 97.0919 116.208 96.0652 116.88 94.4599C117.571 92.8359 117.953 91.9025 118.028 91.6599C118.028 91.2492 118.159 90.9599 118.42 90.7919C118.775 90.5305 119.148 90.6239 119.54 91.0719C119.932 91.5199 120.128 92.0985 120.128 92.8079C120.128 93.0319 119.913 93.6759 119.484 94.7399C119.073 95.7852 118.663 96.7279 118.252 97.5679C117.841 98.3892 117.561 98.8932 117.412 99.0799C117.281 99.2665 117.123 99.3599 116.936 99.3599L116.096 99.0239ZM119.736 84.8559C120.053 84.8559 120.399 84.9492 120.772 85.1359C120.865 85.3599 121.108 85.7239 121.5 86.2279C121.892 86.7319 122.088 87.1332 122.088 87.4319C122.088 88.2345 121.64 88.6359 120.744 88.6359C120.371 88.6359 119.941 88.4119 119.456 87.9639C118.989 87.5159 118.756 87.0399 118.756 86.5359C118.756 86.4425 118.915 86.1532 119.232 85.6679C119.568 85.1639 119.736 84.8932 119.736 84.8559Z" fill="white"/>
							<path d="M125.998 88.6359C126.278 88.5052 126.642 88.4399 127.09 88.4399C127.538 88.4399 127.828 88.4772 127.958 88.5519C128.07 88.5145 128.145 88.4959 128.182 88.4959C128.406 88.4959 128.696 88.6825 129.05 89.0559C129.405 89.4292 129.629 89.7279 129.722 89.9519C129.722 91.3145 129.61 91.9959 129.386 91.9959C129.293 91.9959 129.246 92.0519 129.246 92.1639C129.246 92.4252 129.013 92.7145 128.546 93.0319C128.098 93.3492 127.688 93.5079 127.314 93.5079C127.109 93.4519 126.904 93.3305 126.698 93.1439C126.493 92.9385 126.39 92.7332 126.39 92.5279C126.39 92.5092 126.577 92.2759 126.95 91.8279C127.342 91.3799 127.538 90.9785 127.538 90.6239C127.538 90.4745 127.38 90.3999 127.062 90.3999C126.036 90.8665 125.298 91.3052 124.85 91.7159C124.738 91.9399 124.626 92.0519 124.514 92.0519C124.514 92.0332 124.496 92.0239 124.458 92.0239C124.44 92.0239 124.337 92.1172 124.15 92.3039C123.964 92.4905 123.768 92.7425 123.562 93.0599C123.376 93.3585 123.264 93.6292 123.226 93.8719L123.17 93.9559V94.0959C123.152 94.1332 123.142 94.2079 123.142 94.3199C123.142 94.6185 123.534 95.0665 124.318 95.6639C125.121 96.2425 125.672 96.6905 125.97 97.0079C126.288 97.3065 126.484 97.5772 126.558 97.8199C126.726 98.1559 126.81 98.4545 126.81 98.7159C126.81 99.3505 126.474 99.8452 125.802 100.2C125.149 100.536 124.365 100.704 123.45 100.704C122.536 100.704 121.742 100.508 121.07 100.116C120.398 99.7239 120.053 99.3879 120.034 99.1079C120.034 98.8092 120.137 98.6319 120.342 98.5759C120.529 98.4265 120.79 98.3892 121.126 98.4639C121.518 98.5385 122.004 98.6132 122.582 98.6879C122.956 98.6879 123.301 98.6505 123.618 98.5759C123.954 98.5012 124.122 98.4265 124.122 98.3519C124.122 98.2772 124.048 98.1745 123.898 98.0439C123.749 97.9132 123.59 97.8479 123.422 97.8479C123.422 97.7732 123.049 97.4652 122.302 96.9239C121.574 96.3639 121.21 95.9999 121.21 95.8319C121.21 95.8132 121.22 95.7945 121.238 95.7759V95.6359C121.108 95.6359 120.986 95.4585 120.874 95.1039C120.762 94.7492 120.706 94.4039 120.706 94.0679C120.706 93.0972 121.285 92.0425 122.442 90.9039C123.618 89.7465 124.804 88.9905 125.998 88.6359Z" fill="white"/>
							<path d="M129.469 91.7159C129.395 91.7159 129.357 91.5759 129.357 91.2959V91.1559C129.357 91.0999 129.311 91.0439 129.217 90.9879C129.143 90.9319 129.077 90.8759 129.021 90.8199C128.984 90.7452 129.04 90.6052 129.189 90.3999C129.339 90.1945 129.469 90.0825 129.581 90.0639C129.712 90.0452 129.917 90.0172 130.197 89.9799C130.496 89.9425 130.757 89.9052 130.981 89.8679C131.597 89.7559 132.027 89.5505 132.269 89.2519C132.979 87.4225 133.492 86.3305 133.809 85.9759C134.612 85.5652 135.2 85.6585 135.573 86.2559C135.611 86.3119 135.667 86.3865 135.741 86.4799C135.835 86.5545 135.881 86.6105 135.881 86.6479C135.881 86.6852 135.863 86.7879 135.825 86.9559C135.788 87.1239 135.387 87.9452 134.621 89.4199C134.845 89.4572 135.144 89.4572 135.517 89.4199C136.04 89.3079 136.479 89.2799 136.833 89.3359C137.617 89.3359 138.047 89.7652 138.121 90.6239C138.215 91.1279 137.795 91.3799 136.861 91.3799C134.939 91.4545 133.968 91.5385 133.949 91.6319C133.856 91.6879 133.707 91.9772 133.501 92.4999C133.296 93.0225 133.128 93.5172 132.997 93.9839C132.493 96.3172 132.503 97.7639 133.025 98.3239C133.305 98.6039 133.884 98.3892 134.761 97.6799C135.079 97.4185 135.368 97.3345 135.629 97.4279C135.909 97.5212 136.059 97.7265 136.077 98.0439C136.115 98.3425 136.031 98.6692 135.825 99.0239C135.489 99.5279 134.967 99.9292 134.257 100.228C133.548 100.527 132.969 100.611 132.521 100.48C132.092 100.349 131.551 99.9945 130.897 99.4159C130.599 99.0239 130.412 98.6692 130.337 98.3519C130.281 98.0345 130.253 97.6425 130.253 97.1759V96.3639C130.253 95.9345 130.543 94.5625 131.121 92.2479C131.177 92.0425 131.084 91.9119 130.841 91.8559C130.617 91.7812 130.347 91.7532 130.029 91.7719C129.712 91.7719 129.525 91.7532 129.469 91.7159Z" fill="white"/>
							<path d="M169.448 65.7375C183.032 55.7249 184.713 38.2218 176.254 24.4883C167.64 10.5087 150.614 1.24647 134.378 0.545047C130.995 0.402547 131.068 5.29103 134.289 5.69803C148.362 7.48213 162.047 14.4834 170.375 26.1676C174.02 31.2199 175.982 37.2913 175.983 43.5212C176.024 51.6927 171.693 57.571 167.12 63.8238C166.019 65.3273 168.201 66.6458 169.448 65.7375Z" fill="white" fill-opacity="0.3"/>
							<path d="M158.44 79.009C165.363 75.8493 173.292 72.8225 178.425 66.9463C178.618 66.746 178.727 66.479 178.728 66.2008C178.73 65.9225 178.624 65.6543 178.434 65.4518C178.243 65.2492 177.981 65.1279 177.703 65.113C177.426 65.0981 177.153 65.1907 176.941 65.3716C171.418 69.5769 165.359 72.3273 159.009 74.901C158.446 70.4748 158.586 65.8454 157.351 61.5833C157.242 61.2013 157.002 60.8702 156.672 60.649C156.342 60.4278 155.944 60.3308 155.55 60.3753C155.155 60.4198 154.789 60.6029 154.517 60.8919C154.244 61.181 154.083 61.5574 154.063 61.954C153.909 67.3014 154.503 72.644 155.827 77.8273C155.898 78.092 156.027 78.3376 156.205 78.5465C156.383 78.7554 156.604 78.9223 156.854 79.0353C157.104 79.1483 157.376 79.2045 157.65 79.2C157.924 79.1954 158.194 79.1302 158.44 79.009Z" fill="white" fill-opacity="0.3"/>
						</svg>
                    </div>
                </form> --}}

                <x-button
                    variant="primary"
                    target="_blank"
                    href="https://buy.stripe.com/7sI4hfazDfb9alO6pj"
                >@lang('Join Today')</x-button>
            </div>
        </div>
    </div>
</section>
