# Changelog

All notable changes to `laravel-health` will be documented in this file.

## 1.22.5 - 2023-03-29

### What's Changed

- postgresql database size fix by @SUXUMI in https://github.com/spatie/laravel-health/pull/170

### New Contributors

- @SUXUMI made their first contribution in https://github.com/spatie/laravel-health/pull/170

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.22.4...1.22.5

## 1.22.4 - 2023-03-21

- do not send notification when table sizes are ok

## 1.22.3 - 2023-02-28

### What's Changed

- Update vendor name for Laravel Health Check by @rbibby in https://github.com/spatie/laravel-health/pull/161
- Fix dispatch HealthQueueJob for multiple checks by @faustoFF in https://github.com/spatie/laravel-health/pull/166

### New Contributors

- @rbibby made their first contribution in https://github.com/spatie/laravel-health/pull/161
- @faustoFF made their first contribution in https://github.com/spatie/laravel-health/pull/166

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.22.2...1.22.3

## 1.22.2 - 2023-02-15

### What's Changed

- mysql connection count fix by @maxkalahur in https://github.com/spatie/laravel-health/pull/160

### New Contributors

- @maxkalahur made their first contribution in https://github.com/spatie/laravel-health/pull/160

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.22.1...1.22.2

## 1.22.1 - 2023-02-05

### What's Changed

- Fix redis memory usage check when phpredis is used by @kirba in https://github.com/spatie/laravel-health/pull/158

### New Contributors

- @kirba made their first contribution in https://github.com/spatie/laravel-health/pull/158

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.22.0...1.22.1

## 1.22.0 - 2023-02-02

### What's Changed

- Enable dependency injection in check constructors by @dennis-koster in https://github.com/spatie/laravel-health/pull/157

### New Contributors

- @dennis-koster made their first contribution in https://github.com/spatie/laravel-health/pull/157

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.21.0...1.22.0

## 1.21.0 - 2023-02-02

- add `silence_health_queue_job` config option

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.20.1...1.21.0

## 1.20.1 - 2023-02-02

### What's Changed

- Fix `DatabaseSizeCheck` to not send notifications on passed checks by @felly in https://github.com/spatie/laravel-health/pull/156

### New Contributors

- @felly made their first contribution in https://github.com/spatie/laravel-health/pull/156

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.20.0...1.20.1

## 1.20.0 - 2023-02-01

### What's Changed

- Add redis memory usage check by @stfndamjanovic in https://github.com/spatie/laravel-health/pull/154

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.19.0...1.20.0

## 1.19.0 - 2023-01-25

### What's Changed

- Add DatabaseSizeCheck by @ralphjsmit in https://github.com/spatie/laravel-health/pull/151

### New Contributors

- @ralphjsmit made their first contribution in https://github.com/spatie/laravel-health/pull/151

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.18.3...1.19.0

## 1.18.3 - 2023-01-25

### What's Changed

- Fix empty output when running `artisan health:list --fresh` by @emiliopedrollo in https://github.com/spatie/laravel-health/pull/150

### New Contributors

- @emiliopedrollo made their first contribution in https://github.com/spatie/laravel-health/pull/150

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.18.2...1.18.3

## 1.18.2 - 2023-01-24

### What's Changed

- Laravel 10.x Compatibility by @laravel-shift in https://github.com/spatie/laravel-health/pull/152

### New Contributors

- @laravel-shift made their first contribution in https://github.com/spatie/laravel-health/pull/152

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.18.1...1.18.2

## 1.18.1 - 2023-01-06

### What's Changed

- Add support for PHP 8.2 by @kudashevs in https://github.com/spatie/laravel-health/pull/141
- Some improvements by @kudashevs in https://github.com/spatie/laravel-health/pull/140
- Add queue jobs check by @stfndamjanovic in https://github.com/spatie/laravel-health/pull/143
- Update Queue docs by @driesvints in https://github.com/spatie/laravel-health/pull/146

### New Contributors

- @kudashevs made their first contribution in https://github.com/spatie/laravel-health/pull/141
- @driesvints made their first contribution in https://github.com/spatie/laravel-health/pull/146

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.17.0...1.18.1

## 1.18.0 - 2022-12-28

### What's Changed

- Add support for PHP 8.2 by @kudashevs in https://github.com/spatie/laravel-health/pull/141
- Some improvements by @kudashevs in https://github.com/spatie/laravel-health/pull/140
- Add queue jobs check by @stfndamjanovic in https://github.com/spatie/laravel-health/pull/143

### New Contributors

- @kudashevs made their first contribution in https://github.com/spatie/laravel-health/pull/141

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.17.0...1.18.0

## 1.17.0 - 2022-12-14

### What's Changed

- Running checks conditionally by @stfndamjanovic in https://github.com/spatie/laravel-health/pull/139

### New Contributors

- @stfndamjanovic made their first contribution in https://github.com/spatie/laravel-health/pull/139

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.16.3...1.17.0

## 1.16.3 - 2022-12-02

### What's Changed

- Add Persian translation by @mohammad6006 in https://github.com/spatie/laravel-health/pull/138

### New Contributors

- @mohammad6006 made their first contribution in https://github.com/spatie/laravel-health/pull/138

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.16.2...1.16.3

## 1.16.2 - 2022-11-28

### What's Changed

- Add Slovak translation by @wamesro in https://github.com/spatie/laravel-health/pull/137

### New Contributors

- @wamesro made their first contribution in https://github.com/spatie/laravel-health/pull/137

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.16.1...1.16.2

## 1.16.1 - 2022-11-17

### What's Changed

- Minor fix fake default argument by @patrick-levesque in https://github.com/spatie/laravel-health/pull/136

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.16.0...1.16.1

## 1.16.0 - 2022-11-17

### What's Changed

- Adds the ability to fake registered checks. by @lukeraymonddowning in https://github.com/spatie/laravel-health/pull/135

### New Contributors

- @lukeraymonddowning made their first contribution in https://github.com/spatie/laravel-health/pull/135

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.15.2...1.16.0

## 1.15.2 - 2022-10-21

### What's Changed

- Alias `health` in lieu of a separate binding by @mabdullahsari in https://github.com/spatie/laravel-health/pull/129

### New Contributors

- @mabdullahsari made their first contribution in https://github.com/spatie/laravel-health/pull/129

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.15.1...1.15.2

## 1.15.1 - 2022-10-17

### What's Changed

- Add Danish translation by @prip in https://github.com/spatie/laravel-health/pull/128

### New Contributors

- @prip made their first contribution in https://github.com/spatie/laravel-health/pull/128

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.15.0...1.15.1

## 1.15.0 - 2022-10-07

### What's Changed

- Update endpoints.md by @WouterBrouwers in https://github.com/spatie/laravel-health/pull/124
- Add `retryTimes` method by @mtawil in https://github.com/spatie/laravel-health/pull/123

### New Contributors

- @WouterBrouwers made their first contribution in https://github.com/spatie/laravel-health/pull/124

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.14.6...1.15.0

## 1.14.6 - 2022-09-22

### What's Changed

- Added filesystemName to UsedDiskSpaceCheck by @davidrushton in https://github.com/spatie/laravel-health/pull/122

### New Contributors

- @davidrushton made their first contribution in https://github.com/spatie/laravel-health/pull/122

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.14.5...1.14.6

## 1.14.5 - 2022-09-13

### What's Changed

- Fix store skipped checks results by @patrick-levesque in https://github.com/spatie/laravel-health/pull/120

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.14.4...1.14.5

## 1.14.4 - 2022-09-09

Only report unique checks

## 1.14.3 - 2022-09-08

### What's Changed

- Update via-slack.md by @tomsgad in https://github.com/spatie/laravel-health/pull/116
- fix/removes a comma which should not be there by @Enaah in https://github.com/spatie/laravel-health/pull/117
- Capitalize short summary for PingCheck by @HassanZahirnia in https://github.com/spatie/laravel-health/pull/118

### New Contributors

- @tomsgad made their first contribution in https://github.com/spatie/laravel-health/pull/116
- @Enaah made their first contribution in https://github.com/spatie/laravel-health/pull/117
- @HassanZahirnia made their first contribution in https://github.com/spatie/laravel-health/pull/118

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.14.2...1.14.3

## 1.14.2 - 2022-08-31

### What's Changed

- Slack notification fix by @patrick-levesque in https://github.com/spatie/laravel-health/pull/115

### New Contributors

- @patrick-levesque made their first contribution in https://github.com/spatie/laravel-health/pull/115

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.14.1...1.14.2

## 1.14.1 - 2022-08-24

### What's Changed

- Support PHP 8.0 by @HajMo in https://github.com/spatie/laravel-health/pull/114

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.14.0...1.14.1

## 1.14.0 - 2022-08-16

- Allows you to configure the notification throttle cache key

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.13.0...1.14.0

## 1.13.0 - 2022-08-09

- add "database table size" and "database connection count" checks.

## 1.12.3 - 2022-08-03

- fix for when not all items is the meta array are scalars

## 1.12.2 - 2022-08-03

### What's Changed

- Failed Notification Cache Per Channel by @moisish in https://github.com/spatie/laravel-health/pull/107
- Missing setting $message by @gizburdt in https://github.com/spatie/laravel-health/pull/108

### New Contributors

- @gizburdt made their first contribution in https://github.com/spatie/laravel-health/pull/108

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.12.0...1.12.2

## 1.12.1 - 2022-07-29

### What's Changed

- Failed Notification Cache Per Channel by @moisish in https://github.com/spatie/laravel-health/pull/107
- Missing setting $message by @gizburdt in https://github.com/spatie/laravel-health/pull/108

### New Contributors

- @gizburdt made their first contribution in https://github.com/spatie/laravel-health/pull/108

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.12.0...1.12.1

## 1.12.0 - 2022-07-15

### What's Changed

- Minor fix docs by @Joel-Jensen in https://github.com/spatie/laravel-health/pull/105
- Added "cached services" check by @rcerljenko and @freekmurze in https://github.com/spatie/laravel-health/pull/106

### New Contributors

- @Joel-Jensen made their first contribution in https://github.com/spatie/laravel-health/pull/105

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.11.1...1.12.0

## 1.11.1 - 2022-06-30

### What's Changed

- Added translation for Bangla by @rakibdevs in https://github.com/spatie/laravel-health/pull/104

### New Contributors

- @rakibdevs made their first contribution in https://github.com/spatie/laravel-health/pull/104

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.11.0...1.11.1

## 1.11.0 - 2022-06-30

### What's Changed

- Notification Message - Add Environment Name with Application Name by @moisish in https://github.com/spatie/laravel-health/pull/103

### New Contributors

- @moisish made their first contribution in https://github.com/spatie/laravel-health/pull/103

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.10.1...1.11.0

## 1.10.1 - 2022-06-29

- make it easy to override the notification class name in the run checks command.

## 1.10.0 - 2022-06-28

### What's Changed

- Get the exception class name by @mtawil in https://github.com/spatie/laravel-health/pull/100
- Added method and headers helpers to PingCheck by @rcerljenko in https://github.com/spatie/laravel-health/pull/101

### New Contributors

- @mtawil made their first contribution in https://github.com/spatie/laravel-health/pull/100
- @rcerljenko made their first contribution in https://github.com/spatie/laravel-health/pull/101

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.9.2...1.10.0

## 1.9.2 - 2022-05-11

## What's Changed

- Don't set notification message on `ok` by default by @riasvdv in https://github.com/spatie/laravel-health/pull/96

## New Contributors

- @riasvdv made their first contribution in https://github.com/spatie/laravel-health/pull/96

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.9.1...1.9.2

## 1.9.1 - 2022-05-03

## What's Changed

- chore: exclude docs from package archive by @owenvoke in https://github.com/spatie/laravel-health/pull/95

## New Contributors

- @owenvoke made their first contribution in https://github.com/spatie/laravel-health/pull/95

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.9.0...1.9.1

## 1.9.0 - 2022-04-18

## What's Changed

- Fixing typo on Antonio Ribeiro's name. by @eduardocruz in https://github.com/spatie/laravel-health/pull/85
- Add Simple Health Check Endpoint by @abenerd in https://github.com/spatie/laravel-health/pull/89

## New Contributors

- @eduardocruz made their first contribution in https://github.com/spatie/laravel-health/pull/85

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.8.8...1.8.9

## 1.8.8 - 2022-03-14

## What's Changed

- Add indexes to Eloquent health check results table by @JackWH in https://github.com/spatie/laravel-health/pull/83

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.8.7...1.8.8

## 1.8.7 - 2022-03-09

- fix issue #77

## 1.8.6 - 2022-03-08

## What's Changed

- Add spanish translation by @josecl in https://github.com/spatie/laravel-health/pull/82

## New Contributors

- @josecl made their first contribution in https://github.com/spatie/laravel-health/pull/82

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.8.5...1.8.6

## 1.8.5 - 2022-02-21

## What's Changed

- Fix grammar in german translations by @marcreichel in https://github.com/spatie/laravel-health/pull/79

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.8.4...1.8.5

## 1.8.4 - 2022-02-21

## What's Changed

- Add German and Turkish Translations by @remzikocak in https://github.com/spatie/laravel-health/pull/78

## New Contributors

- @remzikocak made their first contribution in https://github.com/spatie/laravel-health/pull/78

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.8.3...1.8.4

## 1.8.3 - 2022-02-20

## What's Changed

- Add arabic translation by @ousid in https://github.com/spatie/laravel-health/pull/76
- Add --fail-command-on-failing-check to health:list artisan command by @eleftrik in https://github.com/spatie/laravel-health/pull/75
- Fix name of the Cache health result store parameter by @andrzejkupczyk in https://github.com/spatie/laravel-health/pull/68

## New Contributors

- @ousid made their first contribution in https://github.com/spatie/laravel-health/pull/76
- @eleftrik made their first contribution in https://github.com/spatie/laravel-health/pull/75
- @andrzejkupczyk made their first contribution in https://github.com/spatie/laravel-health/pull/68

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.8.2...1.8.3

## 1.8.2 - 2022-02-09

## What's Changed

- Fix allChecksOk and containsFailingCheck behaviour by @dominikkukacka in https://github.com/spatie/laravel-health/pull/71

## New Contributors

- @dominikkukacka made their first contribution in https://github.com/spatie/laravel-health/pull/71

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.8.1...1.8.2

## 1.8.1 - 2022-02-02

## What's Changed

- Add NL translation by @ndeblauw in https://github.com/spatie/laravel-health/pull/67

## New Contributors

- @ndeblauw made their first contribution in https://github.com/spatie/laravel-health/pull/67

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.8.0...1.8.1

## 1.8.0 - 2022-02-01

## What's Changed

- feat: Improve `health:list` cli output by @xiCO2k in https://github.com/spatie/laravel-health/pull/66

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.7.14...1.8.0

## 1.7.14 - 2022-01-26

## What's Changed

- Add Italian translation by @michele-grifa in https://github.com/spatie/laravel-health/pull/64

## New Contributors

- @michele-grifa made their first contribution in https://github.com/spatie/laravel-health/pull/64

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.7.13...1.7.14

## 1.7.13 - 2022-01-26

## What's Changed

- Add Portuguese locale by @st693ava in https://github.com/spatie/laravel-health/pull/63

## New Contributors

- @st693ava made their first contribution in https://github.com/spatie/laravel-health/pull/63

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.7.12...1.7.13

## 1.7.12 - 2022-01-26

## What's Changed

- Add Russian translation by @saundefined in https://github.com/spatie/laravel-health/pull/62

## New Contributors

- @saundefined made their first contribution in https://github.com/spatie/laravel-health/pull/62

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.7.11...1.7.12

## 1.7.11 - 2022-01-24

## What's Changed

- Grammar correction by @atoaugustyn in https://github.com/spatie/laravel-health/pull/58
- Add French translation by @lobotomised in https://github.com/spatie/laravel-health/pull/61

## New Contributors

- @atoaugustyn made their first contribution in https://github.com/spatie/laravel-health/pull/58
- @lobotomised made their first contribution in https://github.com/spatie/laravel-health/pull/61

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.7.10...1.7.11

## 1.7.10 - 2022-01-21

- add Bulgarian translation

## 1.7.9 - 2022-01-19

## What's Changed

- Added meta tags for improved (mobile) experience by @nckrtl in https://github.com/spatie/laravel-health/pull/55

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.7.8...1.7.9

## 1.7.8 - 2022-01-19

## What's Changed

- Fixed json response header by @Elnadrion in https://github.com/spatie/laravel-health/pull/53

## New Contributors

- @Elnadrion made their first contribution in https://github.com/spatie/laravel-health/pull/53

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.7.7...1.7.8

## 1.7.7 - 2022-01-18

## What's Changed

- Bugfixes RedisCheck to take the named connection by @ndberg in https://github.com/spatie/laravel-health/pull/51

## New Contributors

- @ndberg made their first contribution in https://github.com/spatie/laravel-health/pull/51

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.7.6...1.7.7

## 1.7.5 - 2021-12-25

## What's Changed

- Add Application Cache check by @michellaurent in https://github.com/spatie/laravel-health/pull/34
- Use CarbonInterface to account for CarbonImmutable by @abenerd in https://github.com/spatie/laravel-health/pull/35

## New Contributors

- @michellaurent made their first contribution in https://github.com/spatie/laravel-health/pull/34

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.7.4...1.7.5

## 1.7.4 - 2021-12-21

- improve meilisearch check

## 1.7.3 - 2021-12-21

- fix label

## 1.7.2 - 2021-12-21

- fix check label

## 1.7.1 - 2021-12-21

- fix meilisearch endpoint

## 1.7.0 - 2021-12-21

- add `MeiliSearchCheck`

## 1.6.0 - 2021-12-17

## What's Changed

- Allow for PingCheck timeout customisation by @JackWH in https://github.com/spatie/laravel-health/pull/32

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.5.1...1.6.0

## 1.5.1 - 2021-12-17

## What's Changed

- Remove url encoding from start/end date in Flare check by @patrickbrouwers in https://github.com/spatie/laravel-health/pull/31

## New Contributors

- @patrickbrouwers made their first contribution in https://github.com/spatie/laravel-health/pull/31

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.5.0...1.5.1

## 1.5.0 - 2021-12-17

## What's Changed

- Add Cache Status by @ahinkle in https://github.com/spatie/laravel-health/pull/30

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.4.2...1.5.0

## 1.4.2 - 2021-12-15

## What's Changed

- fix a tiny typo by @dbakan in https://github.com/spatie/laravel-health/pull/27
- More translations support on health status page by @ahinkle in https://github.com/spatie/laravel-health/pull/24

## New Contributors

- @dbakan made their first contribution in https://github.com/spatie/laravel-health/pull/27

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.4.1...1.4.2

## 1.4.1 - 2021-12-15

## What's Changed

- Fix syntax docs on health checks by @ahinkle in https://github.com/spatie/laravel-health/pull/25
- Use the Logging Slack URL by default by @ahinkle in https://github.com/spatie/laravel-health/pull/26

## New Contributors

- @ahinkle made their first contribution in https://github.com/spatie/laravel-health/pull/25

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.4.0...1.4.1

## 1.4.0 - 2021-12-14

## What's Changed

- Add support for custom HealthCheckResultHistoryItem models by @JackWH in https://github.com/spatie/laravel-health/pull/18

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.3.4...1.4.0

## 1.3.4 - 2021-12-14

- fix output of run command

## 1.3.3 - 2021-12-14

- fix suggested command

## 1.3.2 - 2021-12-13

## What's Changed

- Fix typos in docs by @JackWH in https://github.com/spatie/laravel-health/pull/17
- Fix typos in cpu load documentation by @marcreichel in https://github.com/spatie/laravel-health/pull/19
- Remove `@ray` from view by @marcreichel in https://github.com/spatie/laravel-health/pull/20

## New Contributors

- @JackWH made their first contribution in https://github.com/spatie/laravel-health/pull/17
- @marcreichel made their first contribution in https://github.com/spatie/laravel-health/pull/19

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.3.1...1.3.2

## 1.3.1 - 2021-12-13

## What's Changed

- Update introduction.md by @RichardStyles in https://github.com/spatie/laravel-health/pull/15
- Fix incorrect class name by @vmitchell85 in https://github.com/spatie/laravel-health/pull/14
- Update used-disk-space.md by @tomhrtly in https://github.com/spatie/laravel-health/pull/13
- Fix regular expression for used disk space check output by @SamuelNitsche in https://github.com/spatie/laravel-health/pull/12

## New Contributors

- @RichardStyles made their first contribution in https://github.com/spatie/laravel-health/pull/15
- @vmitchell85 made their first contribution in https://github.com/spatie/laravel-health/pull/14
- @tomhrtly made their first contribution in https://github.com/spatie/laravel-health/pull/13
- @SamuelNitsche made their first contribution in https://github.com/spatie/laravel-health/pull/12

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.3.0...1.3.1

## 1.3.0 - 2021-12-13

## What's Changed

- Updated UI for the local results page + support for dark mode by @nckrtl in https://github.com/spatie/laravel-health/pull/11

## New Contributors

- @nckrtl made their first contribution in https://github.com/spatie/laravel-health/pull/11

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.2.1...1.3.0

## 1.2.1 - 2012-12-11

- improve CLI output

## 1.2.0 - 2021-12-07

- add `PingCheck`
- add extra exceptions around registering checks

## 1.1.0 - 2021-12-07

## What's Changed

- Use correct controller for JSON response by @tominon in https://github.com/spatie/laravel-health/pull/7
- Add factory for HealthCheckResultHistoryItem model by @abenerd in https://github.com/spatie/laravel-health/pull/9
- Simplify url generation for flare error count check by @abenerd in https://github.com/spatie/laravel-health/pull/8

## New Contributors

- @tominon made their first contribution in https://github.com/spatie/laravel-health/pull/7
- @abenerd made their first contribution in https://github.com/spatie/laravel-health/pull/9

**Full Changelog**: https://github.com/spatie/laravel-health/compare/1.0.1...1.1.0

## 1.0.1 - 2021-12-07

- fix list command

## 1.0.0 - 2021-12-07

- initial release

## 0.15.0 - 2021-12-07

- experimental release

## 0.9.2 - 2021-12-07

- experimental release

## 0.9.1 - 2021-12-06

- experimental release

## 0.9.0 - 2021-12-06

- experimental release

## 0.14.0 - 2021-12-06

- experimental release

## 0.13.0 - 2021-12-05

- experimental release

## 0.12.0 - 2021-12-04

- experimental release

## 0.11.0 - 2021-12-03

- experimental release

## 0.10.0 - 2021-11-30

- experimental release

## 0.0.8 - 2021-11-30

- experimental release

## 0.0.7 - 2021-11-27

- experimental release

## 0.0.6 - 2021-11-27

- experimental release

## 0.0.5 - 2021-11-27

- experimental release

## 0.0.4 - 2021-11-26

- experimental release

## 0.0.3 - 2021-11-26

- experimental release

## 0.0.2 - 2021-11-25

- experimental version

## 0.0.1 - 2021-11-22

- experimental release
