<?php $__env->startSection('template_title'); ?>
    <?php echo e(trans('installer_messages.requirements.templateTitle')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <i class="fa fa-list-ul fa-fw" aria-hidden="true"></i>
    <?php echo e(trans('installer_messages.requirements.title')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
	<h4 class="mt-0 mb-5 text-[26px] font-golos"><?php echo e(__('Server Requirements')); ?></h4>
    <?php $__currentLoopData = $requirements['requirements']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $requirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <ul class="text-start mb-6">
            <li class="flex items-center px-5 py-2 mb-6 -mx-5 gap-4 rounded-xl shadow-[0_4px_10px_rgba(0,0,0,0.05)] <?php echo e($phpSupportInfo['supported'] ? 'text-green-500' : 'text-red-600'); ?>">
				<span>
					<?php echo e(strtoupper($type)); ?>

					<?php if($type == 'php'): ?>
					<?php echo e(__('version')); ?> <?php echo e($phpSupportInfo['minimum']); ?> <?php echo e(__('required')); ?>

					<?php endif; ?>
				</span>
                <?php if($type == 'php'): ?>
				<span class="flex items-center gap-1 ms-auto">
					<?php echo e($phpSupportInfo['current']); ?>

					<?php if( $phpSupportInfo['supported'] ): ?>
					<svg class="stroke-green-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path> <path d="M9 12l2 2l4 -4"></path> </svg>
					<?php else: ?>
					<svg class="stroke-red-600" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path> <path d="M12 9v4"></path> <path d="M12 16v.01"></path> </svg>
					<?php endif; ?>
				</span>
                <?php endif; ?>
            </li>
            <?php $__currentLoopData = $requirements['requirements'][$type]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extention => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="flex items-center gap-4 mb-2 <?php echo e($enabled ? 'success' : 'error'); ?>">
					<span class="inline-block min-w-[65px]">
						<?php echo e($extention); ?>

					</span>
					<span class="grow">
						<span class="inline-block w-full h-px bg-black bg-opacity-5"></span>
					</span>
					<?php if( $enabled ): ?>
					<svg class="stroke-green-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path> <path d="M9 12l2 2l4 -4"></path> </svg>
					<?php else: ?>
					<svg class="stroke-red-600" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path> <path d="M12 9v4"></path> <path d="M12 16v.01"></path> </svg>
					<?php endif; ?>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

		<?php if( ! isset($requirements['errors']) && $phpSupportInfo['supported'] ): ?>
		<a class="flex items-center justify-center p-2 gap-2 rounded-xl shadow-[0_4px_10px_rgba(0,0,0,0.05)] transition-all duration-300 font-medium hover:bg-black hover:text-white hover:scale-105" href="<?php echo e(route('LaravelInstaller::environmentWizard')); ?>">
			<?php echo e(__('Next')); ?>

			<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M9 6l6 6l-6 6"></path> </svg>
		</a>
		<?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('vendor.installer.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/furkan/Work/projects/openai/openai-app/resources/views/vendor/installer/requirements.blade.php ENDPATH**/ ?>