<aside class="navbar navbar-vertical navbar-expand-lg navbar-transparent !overflow-hidden max-lg:absolute max-lg:top-[65px] max-lg:left-0 max-lg:w-full max-lg:z-50 max-lg:!bg-white max-lg:!shadow-xl max-lg:min-h-0 max-lg:p-0 max-lg:max-h-[calc(85vh-2rem)] max-lg:overflow-y-auto max-lg:dark:!bg-[--tblr-body-bg] max-lg:rounded-b-[20px] group-[.navbar-shrinked]/body:!overflow-visible">
    <div class="navbar-inner h-full overflow-x-hidden overflow-y-auto max-h-[inherit] max-lg:w-full">
        <div class="p-0 container-fluid max-lg:w-full">
            <h1 class="flex items-center ps-[1.25rem] pe-9 min-h-[--lqd-header-height] max-w-full relative max-lg:hidden group-[.navbar-shrinked]/body:w-full group-[.navbar-shrinked]/body:px-0 group-[.navbar-shrinked]/body:text-center group-[.navbar-shrinked]/body:justify-center">
                <a class="block px-0" href="<?php echo e(LaravelLocalization::localizeUrl( route('dashboard.index') )); ?>">

					<?php if(isset($setting->logo_dashboard)): ?>
						<img src="/<?php echo e($setting->logo_dashboard_path); ?>" <?php if( isset($setting->logo_dashboard_2x_path) ): ?> srcset="/<?php echo e($setting->logo_dashboard_2x_path); ?> 2x" <?php endif; ?> alt="<?php echo e($setting->site_name); ?>" class="h-auto group-[.navbar-shrinked]/body:hidden dark:hidden">
						<img src="/<?php echo e($setting->logo_dashboard_dark_path); ?>" <?php if( isset($setting->logo_dashboard_dark_2x_path) ): ?> srcset="/<?php echo e($setting->logo_dashboard_dark_2x_path); ?> 2x" <?php endif; ?> alt="<?php echo e($setting->site_name); ?>" class="h-auto hidden group-[.navbar-shrinked]/body:hidden dark:block">
					<?php else: ?>
						<img src="/<?php echo e($setting->logo_path); ?>" <?php if( isset($setting->logo_2x_path) ): ?> srcset="/<?php echo e($setting->logo_2x_path); ?> 2x" <?php endif; ?> alt="<?php echo e($setting->site_name); ?>" class="h-auto group-[.navbar-shrinked]/body:hidden dark:hidden">
						<img src="/<?php echo e($setting->logo_dark_path); ?>" <?php if( isset($setting->logo_dark_2x_path) ): ?> srcset="/<?php echo e($setting->logo_dark_2x_path); ?> 2x" <?php endif; ?> alt="<?php echo e($setting->site_name); ?>" class="h-auto hidden group-[.navbar-shrinked]/body:hidden dark:block">
					<?php endif; ?>

					<!-- collapsed -->
					<img src="/<?php echo e($setting->logo_collapsed_path); ?>" <?php if( isset($setting->logo_collapsed_2x_path) ): ?> srcset="/<?php echo e($setting->logo_collapsed_2x_path); ?> 2x" <?php endif; ?> alt="<?php echo e($setting->site_name); ?>" class="h-auto hidden max-w-[40px] mx-auto group-[.navbar-shrinked]/body:block dark:!hidden">
					<img src="/<?php echo e($setting->logo_collapsed_dark_path); ?>" <?php if( isset($setting->logo_collapsed_dark_2x_path) ): ?> srcset="/<?php echo e($setting->logo_collapsed_dark_2x_path); ?> 2x" <?php endif; ?> alt="<?php echo e($setting->site_name); ?>" class="h-auto hidden max-w-[40px] mx-auto group-[.theme-dark.navbar-shrinked]/body:block">

                </a>
            </h1>
            <div class="collapse navbar-collapse" id="navbar-menu">
                <ul class="navbar-nav max-lg:py-4 max-lg:px-3">
                    <li>
                        <div class="nav-link-label transition-all">
							<span class="inline-block text-[10px] font-medium uppercase tracking-widest px-[0.5em] py-[0.35em] rounded-[3px]">
								<?php echo e(__('User')); ?>

							</span>
                        </div>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(activeRoute('dashboard.user.index')); ?>" href="<?php echo e(route('dashboard.user.index')); ?>" >
							<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M4 4h6v6h-6z"></path> <path d="M14 4h6v6h-6z"></path> <path d="M4 14h6v6h-6z"></path> <path d="M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path> </svg>
							</span>
                            <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('Dashboard')); ?>

							</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(activeRoute('dashboard.user.openai.documents.all')); ?>" href="<?php echo e(route('dashboard.user.openai.documents.all')); ?>">
							<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M3 4m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"></path> <path d="M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-10"></path> <path d="M10 12l4 0"></path> </svg>
							</span>
                            <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('Documents')); ?>

							</span>
                        </a>
                    </li>
					<?php if( $setting->feature_ai_writer ): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(activeRoute('dashboard.user.openai.list')); ?>" href="<?php echo e(route('dashboard.user.openai.list')); ?>" >
							<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M5 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"></path> <path d="M9 7l6 0"></path> <path d="M9 11l6 0"></path> <path d="M9 15l4 0"></path> </svg>
							</span>
                            <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('AI Writer')); ?>

							</span>
                        </a>
                    </li>
					<?php endif; ?>
					<?php if( $setting->feature_ai_image ): ?>
					<li class="nav-item">
						<a class="nav-link <?php echo e(route('dashboard.user.openai.generator', 'ai_image_generator') == url()->current() ? 'active' : ''); ?>" href="<?php echo e(route('dashboard.user.openai.generator', 'ai_image_generator')); ?>" >
							<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M15 8h.01"></path> <path d="M3 6a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v12a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3v-12z"></path> <path d="M3 16l5 -5c.928 -.893 2.072 -.893 3 0l5 5"></path> <path d="M14 14l1 -1c.928 -.893 2.072 -.893 3 0l3 3"></path> </svg>
							</span>
							<span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('AI Image')); ?>

							</span>
						</a>
					</li>
					<?php endif; ?>
					<?php if( $setting->feature_ai_chat ): ?>
					<li class="nav-item">
						<a class="nav-link <?php echo e(route('dashboard.user.openai.chat.list') == url()->current() ? 'active' : ''); ?>" href="<?php echo e(route('dashboard.user.openai.chat.list')); ?>">
							<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M3 20l1.3 -3.9a9 8 0 1 1 3.4 2.9l-4.7 1"></path> <path d="M12 12l0 .01"></path> <path d="M8 12l0 .01"></path> <path d="M16 12l0 .01"></path> </svg>
							</span>
							<span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('AI Chat')); ?>

							</span>
						</a>
					</li>
					<?php endif; ?>
					<?php if( $setting->feature_ai_code ): ?>
					<li class="nav-item">
						<a class="nav-link <?php echo e(route('dashboard.user.openai.generator.workbook', 'ai_code_generator') == url()->current() ? 'active' : ''); ?>" href="<?php echo e(route('dashboard.user.openai.generator.workbook', 'ai_code_generator')); ?>">
							<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M8 9l3 3l-3 3"></path> <path d="M13 15l3 0"></path> <path d="M3 4m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"></path> </svg>
							</span>
							<span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('AI Code')); ?>

							</span>
						</a>
					</li>
					<?php endif; ?>
					<?php if( $setting->feature_ai_speech_to_text ): ?>
					<li class="nav-item">
						<a class="nav-link <?php echo e(route('dashboard.user.openai.generator', 'ai_speech_to_text') == url()->current() ? 'active' : ''); ?>" href="<?php echo e(route('dashboard.user.openai.generator', 'ai_speech_to_text')); ?>">
							<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M9 2m0 3a3 3 0 0 1 3 -3h0a3 3 0 0 1 3 3v5a3 3 0 0 1 -3 3h0a3 3 0 0 1 -3 -3z"></path> <path d="M5 10a7 7 0 0 0 14 0"></path> <path d="M8 21l8 0"></path> <path d="M12 17l0 4"></path> </svg>
							</span>
							<span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('AI Speech to Text')); ?>

							</span>
						</a>
					</li>
					<?php endif; ?>
					<?php if( $setting->feature_affilates ): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(activeRoute('dashboard.user.affiliates.index')); ?>" href="<?php echo e(route('dashboard.user.affiliates.index')); ?>" >
							<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M16.7 8a3 3 0 0 0 -2.7 -2h-4a3 3 0 0 0 0 6h4a3 3 0 0 1 0 6h-4a3 3 0 0 1 -2.7 -2"></path> <path d="M12 3v3m0 12v3"></path> </svg>
							</span>
                            <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('Affiliates')); ?>

							</span>
                        </a>
                    </li>
					<?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(activeRoute('dashboard.support.list')); ?>" href="<?php echo e(route('dashboard.support.list')); ?>" >
						<span class="nav-link-icon">
							<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"></path> <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path> <path d="M15 15l3.35 3.35"></path> <path d="M9 15l-3.35 3.35"></path> <path d="M5.65 5.65l3.35 3.35"></path> <path d="M18.35 5.65l-3.35 3.35"></path> </svg>
						</span>
                            <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
							<?php echo e(__('Support')); ?>

						</span>
                        </a>
                    </li>

                    <li>
                        <hr>
                    </li>

                    <li>
                        <div class="nav-link-label transition-all">
						<span class="inline-block text-[10px] font-medium uppercase tracking-widest px-[0.5em] py-[0.35em] rounded-[3px]">
							<?php echo e(__('Links')); ?>

						</span>
                        </div>
                    </li>

                    <li>
                        <a class="nav-link <?php echo e(activeRoute('dashboard.user.openai.list.favorites')); ?>" href="<?php echo e(route('dashboard.user.openai.list.favorites')); ?>">
						<span class="nav-link-icon inline-flex items-center justify-center w-[24px] h-[24px] shrink-0 rounded-[6px] bg-[#7A8193] text-white text-[10px] font-normal">
							<?php echo e(mb_substr(__('Favorites'), 0, 1)); ?>

						</span>
                            <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
							<?php echo e(__('Favorites')); ?>

						</span>
                        </a>
                    </li>
                    <li>
                        <a class="nav-link <?php echo e(activeRoute('dashboard.user.openai.documents.all')); ?>" href="<?php echo e(route('dashboard.user.openai.documents.all')); ?>">
						<span class="nav-link-icon inline-flex items-center justify-center w-[24px] h-[24px] shrink-0 rounded-[6px] bg-[#658C8E] text-white text-[10px] font-normal">
							<?php echo e(mb_substr(__('Workbook'), 0, 1)); ?>

						</span>
                            <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
							<?php echo e(__('Workbook')); ?>

						</span>
                        </a>
                    </li>

                    <?php if(Auth::user()->type == 'admin'): ?>
                        <!-- Admin sidebar -->
                        <li>
                            <hr>
                        </li>
                        <li>
                            <div class="nav-link-label transition-all">
							<span class="inline-block text-[10px] font-medium uppercase tracking-widest px-[0.5em] py-[0.35em] rounded-[3px]">
								<?php echo e(__('Admin')); ?>

							</span>
                            </div>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(activeRoute('dashboard.admin.index')); ?>" href="<?php echo e(route('dashboard.admin.index')); ?>" >
								<span class="nav-link-icon">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M4 4h6v6h-6z"></path> <path d="M14 4h6v6h-6z"></path> <path d="M4 14h6v6h-6z"></path> <path d="M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path> </svg>
								</span>
                                <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
									<?php echo e(__('Dashboard')); ?>

								</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(activeRoute('dashboard.admin.users.index')); ?>" href="<?php echo e(route('dashboard.admin.users.index')); ?>" >
								<span class="nav-link-icon">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M9 7m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"></path> <path d="M3 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2"></path> <path d="M16 3.13a4 4 0 0 1 0 7.75"></path> <path d="M21 21v-2a4 4 0 0 0 -3 -3.85"></path> </svg>
								</span>
                                <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
									<?php echo e(__('User Management')); ?>

								</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(activeRoute('dashboard.support.list')); ?>" href="<?php echo e(route('dashboard.support.list')); ?>" >
								<span class="nav-link-icon">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"></path> <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path> <path d="M15 15l3.35 3.35"></path> <path d="M9 15l-3.35 3.35"></path> <path d="M5.65 5.65l3.35 3.35"></path> <path d="M18.35 5.65l-3.35 3.35"></path> </svg>
								</span>
                                <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
									<?php echo e(__('Support Requests')); ?>

								</span>
                            </a>
                        </li>

                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle <?php echo e(activeRouteBulk(['dashboard.admin.openai.list', 'dashboard.admin.openai.custom.list', 'dashboard.admin.openai.chat.list'])); ?>" href="#navbar-help" data-bs-toggle="dropdown" data-bs-auto-close="false" role="button" aria-expanded="false" >
								<span class="nav-link-icon">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M13 5h8"></path> <path d="M13 9h5"></path> <path d="M13 15h8"></path> <path d="M13 19h5"></path> <path d="M3 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z"></path> <path d="M3 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z"></path> </svg>
								</span>
                                <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('Templates')); ?>

								</span>
                            </a>
                            <div class="dropdown-menu <?php echo e(activeRouteBulkShow(['dashboard.admin.openai.list', 'dashboard.admin.openai.custom.list', 'dashboard.admin.openai.chat.list'])); ?>">
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.openai.list')); ?>" href="<?php echo e(route('dashboard.admin.openai.list')); ?>">
                                    <?php echo e(__('Built-in Templates')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.openai.custom.list')); ?>" href="<?php echo e(route('dashboard.admin.openai.custom.list')); ?>">
                                    <?php echo e(__('Custom Templates')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.openai.chat.list')); ?>" href="<?php echo e(route('dashboard.admin.openai.chat.list')); ?>">
                                    <?php echo e(__('Chat Templates')); ?>

                                </a>
                            </div>
                        </li>

                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle <?php echo e(activeRouteBulk(['dashboard.admin.frontend.settings', 'dashboard.admin.frontend.faq.index', 'dashboard.admin.frontend.tools.index', 'dashboard.admin.frontend.whois.index', 'dashboard.admin.frontend.generatorlist.index', 'dashboard.admin.clients.index','dashboard.admin.howitWorks.index', 'dashboard.admin.frontend.sectionsettings'])); ?>" href="#navbar-help" data-bs-toggle="dropdown" data-bs-auto-close="false" role="button" aria-expanded="false" >
								<span class="nav-link-icon">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M3 19l18 0"></path> <path d="M5 6m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z"></path> </svg>
								</span>
                                <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('Frontend')); ?>

								</span>
                            </a>
                            <div class="dropdown-menu <?php echo e(activeRouteBulkShow(['dashboard.admin.frontend.settings', 'dashboard.admin.frontend.faq.index', 'dashboard.admin.frontend.tools.index', 'dashboard.admin.testimonials.index', 'dashboard.admin.frontend.future.index', 'dashboard.admin.frontend.whois.index', 'dashboard.admin.frontend.generatorlist.index', 'dashboard.admin.clients.index','dashboard.admin.howitWorks.index', 'dashboard.admin.frontend.sectionsettings'])); ?>">
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.frontend.settings')); ?>" href="<?php echo e(route('dashboard.admin.frontend.settings')); ?>">
                                    <?php echo e(__('Frontend Settings')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.frontend.sectionsettings')); ?>" href="<?php echo e(route('dashboard.admin.frontend.sectionsettings')); ?>">
                                    <?php echo e(__('Frontend Section Settings')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.frontend.faq.index')); ?>" href="<?php echo e(route('dashboard.admin.frontend.faq.index')); ?>">
                                    <?php echo e(__('F.A.Q')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.frontend.tools.index')); ?>" href="<?php echo e(route('dashboard.admin.frontend.tools.index')); ?>">
                                    <?php echo e(__('Tools Section')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.frontend.future.index')); ?>" href="<?php echo e(route('dashboard.admin.frontend.future.index')); ?>">
                                    <?php echo e(__('Features Section')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.testimonials.index')); ?>" href="<?php echo e(route('dashboard.admin.testimonials.index')); ?>">
                                    <?php echo e(__('Testimonials Section')); ?>

                                </a>
								<a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.clients.index')); ?>" href="<?php echo e(route('dashboard.admin.clients.index')); ?>">
                                    <?php echo e(__('Clients Section')); ?>

                                </a>
								<a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.howitWorks.index')); ?>" href="<?php echo e(route('dashboard.admin.howitWorks.index')); ?>">
                                    <?php echo e(__('How it Works Section')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.frontend.whois.index')); ?>" href="<?php echo e(route('dashboard.admin.frontend.whois.index')); ?>">
                                    <?php echo e(__('Who Can Use Section')); ?>

                                </a>

                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.frontend.generatorlist.index')); ?>" href="<?php echo e(route('dashboard.admin.frontend.generatorlist.index')); ?>">
                                    <?php echo e(__('Generators List Section')); ?>

                                </a>
                            </div>
                        </li>

                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle <?php echo e(activeRouteBulk(['dashboard.admin.finance.plans.index'])); ?>" href="#navbar-help" data-bs-toggle="dropdown" data-bs-auto-close="false" role="button" aria-expanded="false" >
							<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M17 8v-3a1 1 0 0 0 -1 -1h-10a2 2 0 0 0 0 4h12a1 1 0 0 1 1 1v3m0 4v3a1 1 0 0 1 -1 1h-12a2 2 0 0 1 -2 -2v-12"></path> <path d="M20 12v4h-4a2 2 0 0 1 0 -4h4"></path> </svg>
							</span>
                                <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
								<?php echo e(__('Finance')); ?>

							</span>
                            </a>
                            <div class="dropdown-menu <?php echo e(activeRouteBulkShow(['dashboard.admin.finance.plans.index'])); ?>">
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.finance.plans.index')); ?>" href="<?php echo e(route('dashboard.admin.finance.plans.index')); ?>">
                                    <?php echo e(__('Membership Plans')); ?>

                                </a>
								<a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.finance.paymentGateways.index')); ?>" href="<?php echo e(route('dashboard.admin.finance.paymentGateways.index')); ?>">
                                    <?php echo e(__('Payment Gateways')); ?>

                                </a>
                            </div>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(activeRoute('dashboard.page.list')); ?>" href="<?php echo e(route('dashboard.page.list')); ?>" >
								<span class="nav-link-icon">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M14 3v4a1 1 0 0 0 1 1h4"></path><path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z"></path><path d="M9 17h6"></path><path d="M9 13h6"></path></svg>								</span>
                                <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
									<?php echo e(__('Pages')); ?>

								</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(activeRoute('dashboard.admin.affiliates.index')); ?>" href="<?php echo e(route('dashboard.admin.affiliates.index')); ?>" >
								<span class="nav-link-icon">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M14 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path> <path d="M12 9.765a3 3 0 1 0 0 4.47"></path> <path d="M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"></path> </svg>
								</span>
									<span class="flex items-center transition-[opacity,transform] nav-link-title grow">
									<?php echo e(__('Affiliates')); ?>

								</span>
                            </a>
                        </li>

                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle <?php echo e(activeRouteBulk(['dashboard.admin.settings.general', 'dashboard.admin.settings.invoice', 'dashboard.admin.settings.payment', 'dashboard.admin.settings.openai', 'dashboard.admin.settings.affiliate'])); ?>" href="#navbar-help" data-bs-toggle="dropdown" data-bs-auto-close="false" role="button" aria-expanded="false" >
								<span class="nav-link-icon">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M4 8h4v4h-4z"></path> <path d="M6 4l0 4"></path> <path d="M6 12l0 8"></path> <path d="M10 14h4v4h-4z"></path> <path d="M12 4l0 10"></path> <path d="M12 18l0 2"></path> <path d="M16 5h4v4h-4z"></path> <path d="M18 4l0 1"></path> <path d="M18 9l0 11"></path> </svg>
								</span>
									<span class="flex items-center transition-[opacity,transform] nav-link-title grow">
									<?php echo e(__('Settings')); ?>

								</span>
                            </a>
                            <div class="dropdown-menu <?php echo e(activeRouteBulkShow(['dashboard.admin.settings.general', 'dashboard.admin.settings.invoice', 'dashboard.admin.settings.payment', 'dashboard.admin.settings.openai', 'dashboard.admin.settings.affiliate','dashboard.admin.settings.smtp', 'amamarul.translations.home'])); ?>">
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.settings.general')); ?>" href="<?php echo e(route('dashboard.admin.settings.general')); ?>">
                                    <?php echo e(__('General')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.settings.invoice')); ?>" href="<?php echo e(route('dashboard.admin.settings.invoice')); ?>">
                                    <?php echo e(__('Invoice')); ?>

                                </a>
                                <!-- <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.settings.payment')); ?>" href="<?php echo e(route('dashboard.admin.settings.payment')); ?>">
                                    <?php echo e(__('Payment Stripe Settings')); ?>

                                </a> -->
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.settings.openai')); ?>" href="<?php echo e(route('dashboard.admin.settings.openai')); ?>">
                                    <?php echo e(__('OpenAI')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.settings.affiliate')); ?>" href="<?php echo e(route('dashboard.admin.settings.affiliate')); ?>">
                                    <?php echo e(__('Affiliate')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('dashboard.admin.settings.smtp')); ?>" href="<?php echo e(route('dashboard.admin.settings.smtp')); ?>">
                                    <?php echo e(__('SMTP')); ?>

                                </a>
                                <a class="dropdown-item <?php echo e(activeRoute('amamarul.translations.home')); ?>" href="<?php echo e(route('amamarul.translations.home')); ?>">
                                    <?php echo e(__('Translate Strings')); ?>

                                </a>
                            </div>
                        </li>

						<li class="nav-item">
                            <a class="nav-link !pe-2 <?php echo e(activeRoute('dashboard.admin.health.index')); ?>" href="<?php echo e(route('dashboard.admin.health.index')); ?>" >
								<span class="nav-link-icon">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M3 12h4l3 8l4 -16l3 8h4"></path></svg>
								</span>
                                <span class="flex items-center transition-[opacity,transform] nav-link-title grow">
									<?php echo e(__('Site Health')); ?>

								</span>
                            </a>
                        </li>

						<li class="nav-item">
                            <a class="nav-link nav-link--update !pe-2 <?php echo e(activeRoute('dashboard.admin.update.index')); ?>" href="<?php echo e(route('dashboard.admin.update.index')); ?>" >
								<span class="nav-link-icon">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M20 11a8.1 8.1 0 0 0 -15.5 -2m-.5 -4v4h4"></path><path d="M4 13a8.1 8.1 0 0 0 15.5 2m.5 4v-4h-4"></path></svg>
								</span>
                                <span class="flex items-center justify-between transition-[opacity,transform] nav-link-title grow">
									<?php echo e(__('Update')); ?>

								</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item h-[auto] transition-all group-[.navbar-shrinked]/body:opacity-0 group-[.navbar-shrinked]/body:translate-x-3 group-[.navbar-shrinked]/body:h-0 group-[.navbar-shrinked]/body:overflow-hidden">
                        <hr>
                        <div class="nav-link-label mb-2 transition-all">
							<span class="inline-block text-[10px] font-medium uppercase tracking-widest px-[0.5em] py-[0.35em] rounded-[3px]">
								<?php echo e(__('Credits')); ?>

							</span>
                        </div>
                        <div class="px-[1.428rem]">
                            <div class="flex flex-col mb-2">
                                <div class="d-flex align-items-center">
                                    <span class="legend !me-2 rounded-full bg-primary"></span>
                                    <span><?php echo e(__('Word')); ?></span>
                                    <span class="ms-2">
                                        <?php if(Auth::user()->remaining_words == -1): ?>
                                            Unlimited
                                        <?php else: ?>
                                            <?php echo e(number_format((int)Auth::user()->remaining_words)); ?>

                                        <?php endif; ?>
                                    </span>
                                </div>
                                <div class="d-flex align-items-center">
                                    <span class="legend !me-2 rounded-full bg-[#9E9EFF]"></span>
                                    <span><?php echo e(__('Image')); ?></span>
                                    <span class="ms-2">
                                        <?php if(Auth::user()->remaining_images == -1): ?>
                                            Unlimited
                                        <?php else: ?>
                                            <?php echo e(number_format((int)Auth::user()->remaining_images)); ?>

                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                            <div class="mb-2 progress progress-separated">
                                <?php if((int)Auth::user()->remaining_words+(int)Auth::user()->remaining_images != 0): ?>
                                    <div class="progress-bar grow-0 shrink-0 basis-auto bg-primary" role="progressbar" style="width: <?php echo e((int)Auth::user()->remaining_words/((int)Auth::user()->remaining_words+(int)Auth::user()->remaining_images)*100); ?>%" aria-label="<?php echo e(__('Text')); ?>"></div>
                                <?php endif; ?>
                                <?php if((int)Auth::user()->remaining_words+(int)Auth::user()->remaining_images != 0): ?>
                                    <div class="progress-bar grow-0 shrink-0 basis-auto bg-[#9E9EFF]" role="progressbar" style="width: <?php echo e((int)Auth::user()->remaining_images/((int)Auth::user()->remaining_words+(int)Auth::user()->remaining_images)*100); ?>%" aria-label="<?php echo e(__('Images')); ?>"></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </li>
                    <li class="nav-item h-[auto] transition-all group-[.navbar-shrinked]/body:opacity-0 group-[.navbar-shrinked]/body:translate-x-3 group-[.navbar-shrinked]/body:h-0 group-[.navbar-shrinked]/body:overflow-hidden">
                        <hr>
                        <div class="nav-link-label transition-all">
							<span class="inline-block text-[10px] font-medium uppercase tracking-widest px-[0.5em] py-[0.35em] rounded-[3px]">
								<?php echo e(__('Affiliation')); ?>

							</span>
                        </div>
                        <div class="nav-link-label transition-all">
                            <div class="inline-block text-center text-[13px] leading-none text-muted border-solid border-[var(--tblr-border-color)] rounded-[var(--tblr-border-radius)] p-[1rem_2rem]">
                                <p class="not-italic text-[20px] m-0 mb-2">🎁</p>
								<span class="hidden group-[.navbar-shrinked]/body:inline"><. class="not-italic text-[20px] m-0 mb-2"substr(>🎁</, 0, 1)p></span>
                                <p class="mb-[0.75em]"><?php echo e(__('Invite your friend and get')); ?> <?php echo e($setting->affiliate_commission_percentage); ?>% <?php echo e(__('on their all purchases.')); ?></p>
                                <p class="m-0">
                                    <a href="<?php echo e(route('dashboard.user.affiliates.index')); ?>" class="btn btn-sm text-[11px]"><?php echo e(__('Invite')); ?></a>
                                </p>
                            </div>
                        </div>
                    </li>
                </ul>

            </div>
        </div>
    </div>
</aside>
<!-- Navbar -->
<header class="navbar navbar-expand-md navbar-light flex max-lg:h-[65px]">
    <div class="container-xl flex-nowrap !items-stretch">
		<div class="hidden items-center max-lg:flex max-lg:gap-3">
			<button class="navbar-toggler collapsed max-lg:!block" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu" aria-controls="navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
			<a class="hidden max-lg:flex items-center justify-center shrink-0 lg:px-2 max-md:max-w-[120px]" href=".">
				<img src="/<?php echo e($setting->logo_path); ?>" alt="MagicAI" class="">
			</a>
		</div>
        <div class="navbar-nav flex-row justify-end max-lg:basis-[65%]">
            <div class="flex gap-[18px] max-lg:gap-2">
				<div class="flex items-center max-xl:gap-2 max-lg:hidden xl:gap-3">
					<?php if(Auth::user()->type == 'admin'): ?>
					<a class="btn" href="<?php echo e(route('dashboard.admin.index')); ?>" >
						<svg class="hidden max-lg:block" xmlns="http://www.w3.org/2000/svg" height="20" fill="currentColor" viewBox="0 96 960 960" width="20"><path d="M690.882 786q25.883 0 44-19Q753 748 753 722.118q0-25.883-18.118-44-18.117-18.118-44-18.118Q665 660 646 678.118q-19 18.117-19 44Q627 748 646 767q19 19 44.882 19ZM689.5 911q33.5 0 60.5-14t46-40q-26-14-51.962-21-25.961-7-54-7-28.038 0-54.538 7-26.5 7-51.5 21 19 26 45.5 40t60 14Zm3 65Q615 976 560 920.5T505 789q0-78.435 54.99-133.718Q614.98 600 693 600q77 0 132.5 55.282Q881 710.565 881 789q0 76-55.5 131.5t-133 55.5ZM480 976q-138-32-229-156.5T160 534V295l320-120 320 120v270q-25-12-52-18.5t-55-6.5q-102.743 0-175.371 72.921Q445 685.843 445 789q0 48 19.5 94t53.5 80q-9 5-19 7.5t-19 5.5Z"/></svg>
						<span class="max-lg:hidden"><?php echo e(__('Admin Panel')); ?></span>
					</a>
					<?php endif; ?>
					<?php if(getSubscriptionStatus()): ?>
						<a class="btn max-xl:hidden" href="<?php echo e(route('dashboard.user.payment.subscription')); ?>">
							<?php echo e(getSubscriptionName()); ?> - <?php echo e(getSubscriptionDaysLeft()); ?> <?php echo e(__('Days Left')); ?>

						</a>
					<?php else: ?>
						<a class="btn max-xl:hidden" href="<?php echo e(route('dashboard.user.payment.subscription')); ?>">
							<?php echo e(__('No Active Subscription')); ?>

						</a>
					<?php endif; ?>
					<a class="btn btn-primary" href="<?php echo e(route('dashboard.user.payment.subscription')); ?>">
						<svg class="md:me-2 max-lg:w-[20px] max-lg:h-[20px]" width="11" height="15" viewBox="0 0 11 15" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
							<path d="M6.6 0L0 9.375H4.4V15L11 5.625H6.6V0Z" />
						</svg>
						<span class="max-lg:hidden"><?php echo e(__('Upgrade')); ?></span>
					</a>
				</div>
                <div class="flex items-center">
                    <a href="?theme=dark" class="nav-link items-center justify-center px-0 hide-theme-dark hover:!bg-transparent max-lg:w-10 max-lg:h-10 max-lg:p-0 max-lg:border max-lg:border-solid max-lg:border-[--tblr-border-color] max-lg:!rounded-full max-lg:dark:bg-white max-lg:dark:bg-opacity-[0.03]" title="Enable dark mode">
                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 3c.132 0 .263 0 .393 0a7.5 7.5 0 0 0 7.92 12.446a9 9 0 1 1 -8.313 -12.454z" /></svg>
                    </a>
                    <a href="?theme=light" class="nav-link items-center justify-center px-0 hide-theme-light hover:!bg-transparent max-lg:w-10 max-lg:h-10 max-lg:p-0 max-lg:border max-lg:border-solid max-lg:border-[--tblr-border-color] max-lg:!rounded-full max-lg:dark:bg-white max-lg:dark:bg-opacity-[0.03]" title="Enable light mode">
                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0" /><path d="M3 12h1m8 -9v1m8 8h1m-9 8v1m-6.4 -15.4l.7 .7m12.1 -.7l-.7 .7m0 11.4l.7 .7m-12.1 -.7l-.7 .7" /></svg>
                    </a>
                </div>
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link px-0 hover:!bg-transparent max-lg:w-10 max-lg:h-10 max-lg:p-0 max-lg:border max-lg:border-solid max-lg:border-[--tblr-border-color] max-lg:!rounded-full max-lg:dark:bg-white max-lg:dark:bg-opacity-[0.03]" data-bs-toggle="dropdown" tabindex="-1" aria-label="Show notifications">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0"></path> <path d="M3.6 9h16.8"></path> <path d="M3.6 15h16.8"></path> <path d="M11.5 3a17 17 0 0 0 0 18"></path> <path d="M12.5 3a17 17 0 0 1 0 18"></path> </svg>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end">
						<div class="flex flex-col">
                            <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<a rel="alternate" hreflang="<?php echo e($localeCode); ?>" href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>" class="flex items-center px-3 py-2 border-solid border-[--tblr-border-color] border-t-0 border-r-0 border-l-0 last:border-b-0 text-heading transition-colors hover:no-underline hover:bg-[--tblr-border-color]">
								<span class="text-[21px] !me-2"><?php echo e(country2flag(substr($properties['regional'], strrpos($properties['regional'], '_') + 1))); ?> </span><?php echo e($properties['native']); ?>

							</a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</div>
                    </div>
                </div>
				<div class="hidden items-center max-lg:flex">
					<a href="<?php echo e(route('dashboard.user.payment.subscription')); ?>" class="inline-flex items-center justify-center text-current w-10 h-10 p-0 border border-solid !border-[--tblr-border-color] !rounded-full dark:bg-white dark:bg-opacity-[0.03]">
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M13 3l0 7l6 0l-8 11l0 -7l-6 0l8 -11"></path></svg>
					</a>
				</div>
				<div class="nav-item dropdown">
					<a href="#" class="p-0 nav-link d-flex lh-1 text-reset" data-bs-toggle="dropdown" aria-label="Open user menu">
						<span class="avatar avatar-sm max-lg:w-10 max-lg:h-10" style="background-image: url(/<?php echo e(Auth::user()->avatar); ?>)"></span>
					</a>
					<div class="dropdown-menu dropdown-menu-end">
						<div class="dropdown-item disabled">
							<div>
								<div><?php echo e(Auth::user()->fullName()); ?></div>
								<div class="mt-1 small text-muted"><?php echo e(Auth::user()->email); ?></div>
							</div>
						</div>
						<div class="dropdown-divider"></div>
						<div class="dropdown-item disabled">
							<li class="nav-item">
								<div class="mb-3 progress progress-separated">
									<?php if((int)Auth::user()->remaining_words+(int)Auth::user()->remaining_images != 0): ?>
										<div class="progress-bar grow-0 shrink-0 basis-auto bg-primary" role="progressbar" style="width: <?php echo e((int)Auth::user()->remaining_words/((int)Auth::user()->remaining_words+(int)Auth::user()->remaining_images)*100); ?>%" aria-label="Text"></div>
									<?php endif; ?>
									<?php if((int)Auth::user()->remaining_words+(int)Auth::user()->remaining_images != 0): ?>
										<div class="progress-bar grow-0 shrink-0 basis-auto bg-[#9E9EFF]" role="progressbar" style="width: <?php echo e((int)Auth::user()->remaining_images/((int)Auth::user()->remaining_words+(int)Auth::user()->remaining_images)*100); ?>%" aria-label="Images"></div>
									<?php endif; ?>
								</div>
								<div class="row">
									<div class="col-auto d-flex align-items-center">
										<span class="legend !me-2 rounded-full bg-primary"></span>
										<span><?php echo e(__('Word Credits')); ?></span>
										<span class="d-none d-md-inline d-lg-none d-xxl-inline ms-2 text-muted"><?php echo e(number_format((int)Auth::user()->remaining_words)); ?></span>
									</div>
									<div class="col-auto d-flex align-items-center">
										<span class="legend !me-2 rounded-full bg-[#9E9EFF]"></span>
										<span><?php echo e(__('Image Credits')); ?></span>
										<span class="d-none d-md-inline d-lg-none d-xxl-inline ms-2 text-muted"><?php echo e(number_format((int)Auth::user()->remaining_images)); ?></span>
									</div>
								</div>
							</li>
						</div>
						<div class="dropdown-divider"></div>
						<a class="dropdown-item <?php echo e(activeRoute('dashboard.user.payment.subscription')); ?>" href="<?php echo e(route('dashboard.user.payment.subscription')); ?>" >
							<?php echo e(__('Plan')); ?>

						</a>
						<a class="dropdown-item <?php echo e(activeRoute('dashboard.user.orders.index')); ?>" href="<?php echo e(route('dashboard.user.orders.index')); ?>" >
							<?php echo e(__('Orders')); ?>

						</a>
						<a class="dropdown-item <?php echo e(activeRouteBulk(['dashboard.user.settings.index'])); ?>" href="<?php echo e(route('dashboard.user.settings.index')); ?>" >
							<?php echo e(__('Settings')); ?>

						</a>
						<form id="logout" method="POST" action="<?php echo e(route('logout')); ?>">
							<?php echo csrf_field(); ?>
						</form>
						<a href="javascript:;" onclick="document.getElementById('logout').submit();" class="dropdown-item"><?php echo e(__('Logout')); ?></a>
					</div>
				</div>
            </div>
        </div>
		<div class="flex items-center lg:-order-1 max-lg:w-full max-lg:fixed max-lg:bottom-16 max-lg:left-0 max-lg:z-50">
			<form class="navbar-search group !me-2 max-lg:hidden max-lg:[&.show]:flex max-lg:[&.collapsing]:flex max-lg:m-0 max-lg:w-full max-lg:!me-0" id="navbar-search" autocomplete="off" novalidate>
				<div class="w-full input-icon max-lg:p-3 max-lg:bg-[#fff] max-lg:dark:bg-zinc-800">
					<span class="input-icon-addon">
						<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0" /><path d="M21 21l-6 -6" /></svg>
					</span>
					<input type="search" class="form-control navbar-search-input peer max-lg:!rounded-md dark:!bg-zinc-900" id="top_search_word" onkeydown="return event.key != 'Enter';" placeholder="<?php echo e(__('Search for templates and documents...')); ?>" aria-label="Search in website">
					<kbd class="inline-block absolute top-1/2 !end-[12px] -translate-y-1/2 bg-[var(--tblr-bg-surface)] transition-all pointer-events-none peer-focus:opacity-0 peer-focus:invisible peer-focus:scale-70 group-[.is-searching]:opacity-0 group-[.is-searching]:invisible max-lg:hidden">cmd + K</kbd>
					<span class="absolute top-1/2 -translate-y-1/2 !end-[20px]">
						<span class="spinner-border spinner-border-sm text-muted hidden group-[.is-searching]:block" role="status"></span>
					</span>
					<span class="absolute !end-3 top-1/2 -translate-y-1/2 -translate-x-2 transition-all opacity-0 pointer-events-none peer-focus:!opacity-100 peer-focus:translate-x-0  group-[.is-searching]:hidden group-[.done-searching]:hidden rtl:-scale-x-100">
						<svg xmlns="http://www.w3.org/2000/svg" height="25" viewBox="0 96 960 960" width="25" fill="currentColor"><path d="m375 816-43-43 198-198-198-198 43-43 241 241-241 241Z"/></svg>
					</span>
					<div class="navbar-search-results absolute top-[calc(100%+17px)] !start-0 bg-[#fff] shadow-[0_10px_70px_rgba(0,0,0,0.1)] rounded-md w-[100%] max-h-[380px] overflow-y-auto hidden group-[.done-searching]:block dark:!bg-[--tblr-bg-surface] max-lg:top-auto max-lg:bottom-full max-lg:start-0 max-lg:end-0 max-lg:w-auto" id="search_results" style="z-index: 999;">
						<!-- Search results here -->
						<h3 class="m-0 py-[0.75rem] px-3 border-solid border-b border-t-0 border-r-0 border-l-0 border-[--tblr-border-color] text-[1rem] font-medium"><?php echo e(__('Search results')); ?></h3>
						<div class="search-results-container"></div>
					</div>
				</div>
			</form>
		</div>
    </div>
</header>

<!-- Mobile bottom menu -->
<nav class="bottom-menu hidden flex-wrap h-16 fixed inset-x-0 bottom-0 z-50 bg-[rgba(var(--tblr-body-bg-rgb), 0.1)] backdrop-blur-md backdrop-saturate-150 border-solid border-t border-r-0 border-b-0 border-l-0 border-[--tblr-border-color] text-[13px] font-medium max-lg:flex">
	<ul class="grid grid-cols-4 place-items-center w-full p-0 m-0 list-none">
		<li class="w-full">
			<a class="flex flex-col items-center text-inherit" href="<?php echo e(route('dashboard.user.settings.index')); ?>">
				<svg class="h-8" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path> <path d="M12 10m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path> <path d="M6.168 18.849a4 4 0 0 1 3.832 -2.849h4a4 4 0 0 1 3.834 2.855"></path> </svg>
			</a>
		</li>
		<li class="w-full">
			<a class="flex flex-col items-center text-inherit" href="<?php echo e(route('dashboard.user.openai.documents.all')); ?>">
				<svg class="h-8" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2"></path> <path d="M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z"></path> <path d="M9 12h6"></path> <path d="M9 16h6"></path> </svg>
			</a>
		</li>
		<li class="w-full">
			<button class="flex flex-col items-center w-full h-auto p-0 collapsed bg-transparent text-inherit border-none group" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-search" aria-controls="navbar-search" aria-expanded="false" aria-label="Toggle navigation">
				<svg class="h-8" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"></path> <path d="M21 21l-6 -6"></path> </svg>
			</button>
		</li>
		<li class="w-full">
			<button class="flex flex-col items-center w-full h-auto p-0 collapsed bg-none bg-transparent rounded-full text-inherit border-none group outline-none translate-x-0 transform-gpu" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-templates" aria-controls="navbar-templates" aria-expanded="false" aria-label="Toggle templates">
				<span class="inline-flex items-center justify-center w-[30px] h-[30px] mb-1 relative rounded-full overflow-hidden before:w-full before:h-full before:absolute before:top-0 before:left-0 before:rounded-full before:bg-gradient-to-r before:from-[#8d65e9] before:via-[#5391e4] before:to-[#6bcd94] before:animate-spin-grow">
					<svg class="relative rotate-[135deg] group-[.collapsed]:rotate-0 transition-transform duration-300" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" stroke-width="1.5" stroke="#fff" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M12 5l0 14"></path> <path d="M5 12l14 0"></path> </svg>
				</span>
			</button>
		</li>
	</ul>
</nav>
<div class="collapse fixed right-0 bottom-16 z-20 w-full max-h-[calc(85vh-4rem)] overflow-y-auto rounded-t-2xl shadow-[-5px_-10px_30px_rgba(0,0,0,0.07)] group bg-[#fff] overscroll-contain lg:!hidden dark:bg-zinc-800" id="navbar-templates">
	<ul class="p-0 m-0 h-full relative list-none text-[13px] text-heading font-medium">
		<?php $__currentLoopData = $aiWriters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aiWriter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<li class="relative group">
			<a class="flex items-center gap-2 p-3 py-2 border-solid border-b border-r-0 border-t-0 border-l-0 border-[--tblr-border-color] text-inherit"
                <?php if($aiWriter->type == 'text'): ?>
                    href="<?php echo e(LaravelLocalization::localizeUrl( route('dashboard.user.openai.generator.workbook', $aiWriter->slug))); ?>"
                <?php elseif($aiWriter->type == 'image'): ?>
                   href="<?php echo e(LaravelLocalization::localizeUrl( route('dashboard.user.openai.generator', $aiWriter->slug))); ?>"
                <?php elseif($aiWriter->type == 'audio'): ?>
                   href="<?php echo e(LaravelLocalization::localizeUrl( route('dashboard.user.openai.generator', $aiWriter->slug))); ?>"
                <?php elseif($aiWriter->type == 'code'): ?>
                   href="<?php echo e(LaravelLocalization::localizeUrl( route('dashboard.user.openai.generator.workbook', $aiWriter->slug))); ?>"
                <?php endif; ?>
            >
				<span class="avatar w-9 h-9 [&_svg]:w-[20px] [&_svg]:h-[20px] relative transition-all duration-300" style="background: <?php echo e($aiWriter->color); ?>">
                    <span class="inline-block transition-all duration-300">
						<?php echo html_entity_decode($aiWriter->image); ?>

					</span>
				</span>
                <?php echo e($aiWriter->title); ?>

			</a>
		</li>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</ul>
</div>

<!-- Desktop floating add button -->
<div class="fixed bottom-20 end-12 z-50 hidden lg:block">
	<button class="bg-transparent border-none !outline-none rounded-full w-14 h-14 p-0 overflow-hidden !shadow-lg group collapsed translate-x-0 transform-gpu" type="button" data-bs-toggle="collapse" data-bs-target="#add-new-floating" aria-controls="add-new-floating" aria-expanded="false">
		<span class="inline-flex items-center justify-center w-full h-full mb-1 relative rounded-full overflow-hidden before:w-full before:h-full before:absolute before:top-0 before:left-0 before:rounded-full before:bg-gradient-to-r before:from-[#8d65e9] before:via-[#5391e4] before:to-[#6bcd94] before:animate-spin-grow">
			<svg class="relative rotate-[135deg] group-[.collapsed]:rotate-0 transition-transform duration-300" xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 24 24" stroke-width="3" stroke="#fff" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M12 5l0 14"></path> <path d="M5 12l14 0"></path> </svg>
		</span>
	</button>
	<div id="add-new-floating" class="collapse min-w-[145px] absolute bottom-full !mb-4 end-0 bg-[--tblr-body-bg] shadow-[0_3px_12px_rgba(0,0,0,0.08)] rounded-md text-heading font-medium text-sm dark:bg-zinc-800">
		<span class="block !px-4 !py-2 border-solid border-b border-t-0 border-r-0 border-l-0 !border-black !border-opacity-5 text-heading text-opacity-50 last:border-0 dark:!border-white dark:!border-opacity-5"><?php echo e(__('Items:')); ?></span>
		<ul class="p-0 m-0 list-none">
			<?php if( $setting->feature_ai_writer ): ?>
				<li class="border-solid border-b border-t-0 border-r-0 border-l-0 !border-black !border-opacity-5 last:border-0 dark:!border-white dark:!border-opacity-5">
					<a class="block !px-4 !py-2 relative text-inherit hover:no-underline before:absolute before:inset-0 before:text-current before:bg-current before:opacity-0 before:transition-opacity hover:before:opacity-5 [&.active]:before:opacity-5 <?php echo e(activeRoute('dashboard.user.openai.list')); ?>" href="<?php echo e(route('dashboard.user.openai.list')); ?>"><?php echo e(__('Document')); ?></a>
				</li>
			<?php endif; ?>
			<?php if( $setting->feature_ai_image ): ?>
				<li class="border-solid border-b border-t-0 border-r-0 border-l-0 !border-black !border-opacity-5 last:border-0 dark:!border-white dark:!border-opacity-5">
					<a class="block !px-4 !py-2 relative text-inherit hover:no-underline before:absolute before:inset-0 before:text-current before:bg-current before:opacity-0 before:transition-opacity hover:before:opacity-5 [&.active]:before:opacity-5 <?php echo e(route('dashboard.user.openai.generator', 'ai_image_generator') == url()->current() ? 'active' : ''); ?>" href="<?php echo e(route('dashboard.user.openai.generator', 'ai_image_generator')); ?>"><?php echo e(__('Image')); ?></a>
				</li>
			<?php endif; ?>
			<?php if( $setting->feature_ai_chat ): ?>
				<li class="border-solid border-b border-t-0 border-r-0 border-l-0 !border-black !border-opacity-5 last:border-0 dark:!border-white dark:!border-opacity-5">
					<a class="block !px-4 !py-2 relative text-inherit hover:no-underline before:absolute before:inset-0 before:text-current before:bg-current before:opacity-0 before:transition-opacity hover:before:opacity-5 [&.active]:before:opacity-5 <?php echo e(route('dashboard.user.openai.chat.list') == url()->current() ? 'active' : ''); ?>" href="<?php echo e(route('dashboard.user.openai.chat.list')); ?>"><?php echo e(__('Chat')); ?></a>
				</li>
			<?php endif; ?>
			<?php if( $setting->feature_ai_code ): ?>
				<li class="border-solid border-b border-t-0 border-r-0 border-l-0 !border-black !border-opacity-5 last:border-0 dark:!border-white dark:!border-opacity-5">
					<a class="block !px-4 !py-2 relative text-inherit hover:no-underline before:absolute before:inset-0 before:text-current before:bg-current before:opacity-0 before:transition-opacity hover:before:opacity-5 [&.active]:before:opacity-5 <?php echo e(route('dashboard.user.openai.generator.workbook', 'ai_code_generator') == url()->current() ? 'active' : ''); ?>" href="<?php echo e(route('dashboard.user.openai.generator.workbook', 'ai_code_generator')); ?>"><?php echo e(__('Code')); ?></a>
				</li>
			<?php endif; ?>
			<?php if( $setting->feature_ai_speech_to_text ): ?>
				<li class="border-solid border-b border-t-0 border-r-0 border-l-0 !border-black !border-opacity-5 last:border-0 dark:!border-white dark:!border-opacity-5">
					<a class="block !px-4 !py-2 relative text-inherit hover:no-underline before:absolute before:inset-0 before:text-current before:bg-current before:opacity-0 before:transition-opacity hover:before:opacity-5 [&.active]:before:opacity-5 <?php echo e(route('dashboard.user.openai.generator', 'ai_speech_to_text') == url()->current() ? 'active' : ''); ?>" href="<?php echo e(route('dashboard.user.openai.generator', 'ai_speech_to_text')); ?>"><?php echo e(__('Transcribe')); ?></a>
				</li>
			<?php endif; ?>
		</ul>
	</div>
</div>
<?php /**PATH /Users/furkan/Work/projects/openai/openai-app/resources/views/panel/layout/header.blade.php ENDPATH**/ ?>